% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valid.R
\name{lock_validate}
\alias{lock_validate}
\title{Validate a specific renv lock file}
\usage{
lock_validate(
  path,
  lifeduration = FALSE,
  checkred = list(scope = character(0), flavors = NULL),
  lib.loc = .libPaths(),
  repos = biocran_repos()
)
}
\arguments{
\item{path}{character a path to the \code{renv} lock file, or url.}

\item{lifeduration}{logical if to assess life duration for each package in the library. \verb{MEATCRAN CRANDB} is used for less than 500 packages. The direct web page download from CRAN or local evaluation for newest packages otherwise. Default: FALSE}

\item{checkred}{list with two named fields, \code{scope} and \code{flavor}. \code{scope} of R CRAN check pages statuses to consider, any of \code{c("ERROR", "FAIL", "WARN", "NOTE")}. \code{flavor} vector of machines to consider, which might be retrieved with \code{pacs::cran_flavors()$Flavor}. By default an empty scope field deactivated assessment for \code{checkred} column, and NULL flavor will results in checking all machines. Default \code{list(scope = character(0), flavor = NULL)}}

\item{lib.loc}{character vector. Default: \code{.libPaths()}}

\item{repos}{character vector base URLs of the repositories to use. By default checking CRAN and newest Bioconductor per R version. Default \code{pacs::biocran_repos()}}
}
\value{
data.frame with 2/6/7/8 columns.
\describe{
\item{Package}{character a package name.}
\item{Version.expected.min}{(conditional) (Internet needed) character expected by DESCRIPTION files minimal version. "" means not specified so the newest version.}
\item{Version.expected}{character package version in the renv lock file.}
\item{version_status}{(conditional) numeric -1/0/1 which comes from \code{utils::compareVersion} function.
0 means that we have the same version as required by DESCRIPTION files. -1 means we have too low version installed, this is an error. 1 means we have higher version.}
\item{newest}{ logical (Internet needed) if the installed version is the newest one.}
\item{cran}{logical (Internet needed) if the package is on CRAN, version is not taken into account here.}
\item{checkred}{(Optional) (Internet needed) logical if the NEWEST package contains any specified statuses on CRAN check page.}
\item{lifeduration}{(Optional) (Internet needed) integer number of days a package was released.}
}
}
\description{
This function will be especially useful when renv lock file is built manually.
Checking if packages in the lock file have correct versions taking into account their DESCRIPTION files requirements (\code{c("Depends", "Imports", "LinkingTo")}).
Moreover identifying which packages are newest releases.
Optionally we could add life duration and CRAN check page status for each dependency.
}
\note{
Version.expected.min column not count packages which are not a dependency for any package, so could not be find in DESCRIPTION files.
\code{Version.expected.min} and \code{version_status} are assessed only if there are less than 500 packages in the lock file.
When turn on the \code{lifeduration} option, calculations might be time consuming when there is more than 500 packages.
The \code{crandb} R packages database is a part of \code{METACRAN} project, source:
Csárdi G, Salmon M (2022). \code{pkgsearch}: Search and Query CRAN R Packages. \verb{https://github.com/r-hub/pkgsearch}, \verb{https://r-hub.github.io/pkgsearch/}.
}
\examples{
\dontrun{
# path or url
url <- "https://raw.githubusercontent.com/Polkas/pacs/master/tests/testthat/files/renv_test.lock"
lock_validate(url)

pacs::lock_validate(
  url,
  checkred = list(scope = c("ERROR", "FAIL"), flavors = NULL)
)

pacs::lock_validate(
  url,
  lifeduration = TRUE,
  checkred = list(scope = c("ERROR", "FAIL"), flavors = NULL)
)
}
}
