% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lifeduration.R
\name{pacs_lifeduration}
\alias{pacs_lifeduration}
\title{Packages life duration for a specific version}
\usage{
pacs_lifeduration(
  pacs,
  versions,
  source = c("crandb", "loop_crandb", "loop_cran"),
  lib.loc = .libPaths(),
  repos = biocran_repos()
)
}
\arguments{
\item{pacs}{character vector packages names.``}

\item{versions}{character vector packages versions.}

\item{source}{character one of \code{c("crandb", "loop_crandb", "loop_cran")}.
The \code{"crandb"} works if less than \code{getOption("pacs.crandb_limit")} (currently 500) packages are looked for.
Default: \code{"crandb"}}

\item{lib.loc}{character vector. Is omitted for non NULL version. Default: \code{.libPaths()}}

\item{repos}{character vector repositories. Default \verb{https://cran.rstudio.org}}
}
\value{
data.frame with two columns package name and life duration.
}
\description{
packages life duration for certain versions.
}
\note{
Results are cached for 30 minutes with \code{memoise} package.
The \code{crandb} R packages database is a part of \code{METACRAN} project, source:
Csárdi G, Salmon M (2022). \code{pkgsearch}: Search and Query CRAN R Packages. \verb{https://github.com/r-hub/pkgsearch}, \verb{https://r-hub.github.io/pkgsearch/}.
For \code{source = "loop_cran"}the function will scrap two CRAN URLS. Works only with CRAN packages.
Please as a courtesy to the R CRAN, don't overload their servers by constantly using this function.
}
\examples{
\dontrun{
pacs::pacs_lifeduration(c("dplyr", "tidyr"), c("1.0.0", "1.2.0"))
pacs::pacs_lifeduration(c("dplyr", "tidyr"), c("1.0.0", "1.2.0"), source = "loop_cran")
# last versions
pacs::pacs_lifeduration(c("dplyr", "tidyr"), sapply(c("dplyr", "tidyr"), pacs::pac_last))
}
}
