% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pact.R
\name{predict.pact}
\alias{predict.pact}
\title{Predictions from a predictive model fit}
\usage{
\method{predict}{pact}(object, newxv, ...)
}
\arguments{
\item{object}{The object returned from \code{pact.fit}}

\item{newxv}{The dataframe Xv of covariates for the new subjects for whom predictions 
are to be made}

\item{...}{Other arguments to 'predict'}
}
\value{
A numeric vector containing the predicted scores for the new subjects 
from the fitted model is returned
}
\description{
Predicts the scores for new subjects from a previously developed object of class 'pact'
}
\details{
Returns the scores for new subjects from an object of class 'pact', given their covariate values and 
treatment assignment.
}
\examples{
### Survival response
data(prostateCancer)
Y <- prostateCancer[1:400,3:4]
Xf <- prostateCancer[1:400,7:8]
Xv <- prostateCancer[1:400,c(5:6,9)]
Treatment <- as.factor(prostateCancer[1:400,2])
p <- pact.fit(Y=Y, Xf=Xf, Xv=Xv, Treatment=Treatment, family="cox", varSelect="univar")

newxv <- prostateCancer[401:410,c(5:6,9)]
predict(p, newxv)

### Binary response
data(EORTC10994)
Y <- as.factor(EORTC10994[1:120,4])
Xv <- EORTC10994[1:120,c(2,5:7)]
Treatment <- as.factor(EORTC10994[1:120,3])
p <- pact.fit(Y=Y,Xv=Xv,Treatment=Treatment,family="binomial",varSelect="none")

newxv <- EORTC10994[121:125,c(2,5:7)]
predict(p, newxv)
}
\author{
Jyothi Subramanian and Richard Simon
\cr Maintainer: Jyothi Subramanian <\email{subramanianj01@gmail.com}>
}

