% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2dii.plot.R
\name{qplot_techmix}
\alias{qplot_techmix}
\title{Create a quick techmix plot}
\usage{
qplot_techmix(data)
}
\arguments{
\item{data}{A data frame like the output of \code{prep_techmix()}.}
}
\value{
An object of class "ggplot".
}
\description{
Compared to \code{\link[r2dii.plot:plot_techmix]{plot_techmix()}} this function:
\itemize{
\item is restricted to plotting future as 5 years from the start year,
\item outputs pretty bar labels, based on metric column,
\item outputs pretty legend labels, based on technology column,
\item outputs a title.
}
}
\examples{
# `data` must meet documented "Requirements"
data <- subset(
  market_share,
  sector == "power" &
    region == "global" &
    scenario_source == "demo_2020" &
    metric \%in\% c("projected", "corporate_economy", "target_sds")
)

qplot_techmix(data)
}
\seealso{
Other plotting functions: 
\code{\link{plot_emission_intensity}()},
\code{\link{plot_techmix}()},
\code{\link{plot_trajectory}()},
\code{\link{prep_emission_intensity}()},
\code{\link{prep_techmix}()},
\code{\link{prep_trajectory}()},
\code{\link{qplot_emission_intensity}()},
\code{\link{qplot_trajectory}()},
\code{\link{recode_metric_techmix}()},
\code{\link{recode_metric_trajectory}()},
\code{\link{scale_colour_r2dii}()},
\code{\link{scale_colour_r2dii_sector}()},
\code{\link{scale_colour_r2dii_tech}()},
\code{\link{scale_fill_r2dii}()},
\code{\link{scale_fill_r2dii_sector}()},
\code{\link{scale_fill_r2dii_tech}()},
\code{\link{spell_out_technology}()},
\code{\link{theme_2dii}()},
\code{\link{to_title}()}
}
\concept{plotting functions}
