% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yield.R
\name{pa_yield}
\alias{pa_yield}
\title{Create an interpolated yield object from raw data}
\usage{
pa_yield(
  input,
  data.columns = NULL,
  data.units = NULL,
  grid = NULL,
  algorithm = c("none", "simple", "ritas"),
  formula = NULL,
  overlap.threshold = 0.5,
  var.label = "yield",
  boundary = NULL,
  clean = FALSE,
  clean.sd = 3,
  clean.edge.distance = 0,
  smooth.method = c("none", "krige", "idw"),
  fun = c("none", "log"),
  lbs.per.bushel = NULL,
  moisture.adj = NULL,
  lag.adj = 0,
  unit.system = c("none", "metric", "standard"),
  remove.crossed.polygons = FALSE,
  cores = 1L,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{input}{an sf object containing the raw yield
monitor data}

\item{data.columns}{When algorithm is \sQuote{simple},
 this argument should be a vector of length 2 or 3
 (depends on whether the user wants to adjust for time
 lag) indicating which column contains the yield data
, a column containing moisture
 information, and a column indicating the time between
 readings. When algorithm is \sQuote{ritas}, an optional
 named vector with the column names for the variables
 \sQuote{mass, flow, moisture, interval, angle, swath,
 distance}. If a an unnamed vector is supplied, the
 vector is assumed to be in this order. The default is
 NULL, in which case the function attempts to guess the
 columns by using a dictionary of possible guesses.}

\item{data.units}{When algorithm is \sQuote{simple},
should be a vector of length two, indicating the units
of the yield column and the moisture column. Common
values would be \sQuote{c('bu/ac', '\%')}. When
algorithm is \sQuote{ritas}, an optional named vector
with strings representing units for the variables
\sQuote{mass, flow, moisture, interval, angle, swath,
distance}. If a an unnamed vector is supplied, the
vector is assumed to be in this order. A typical value
for this argument would be \sQuote{c(flow = 'lb/s',
moisture = '\%', interval = 's', angle = 'degreeN',
width = 'ft', distance = 'ft')}. Please see
\link[units]{valid_udunits} for help with specifying
units. The default is NULL, in which case the function
attempts to guess the units according to the values of
the variable.}

\item{grid}{an sf object containing the prediction grid.
If the user is processing yield data coming from a
research trial (i.e. follows a trial design), the user
can pass the sf object containing the trial design
information to this argument. If the argument
\sQuote{formula} contains any predictions, the
predictor should be included in the sf object supplied
to this argument. polygons for which the predictions
generated}

\item{algorithm}{algorithm used to generate the yield
object.}

\item{formula}{formula defining the relationship between
the dependent and independent variables. If the
dependent variable is a linear function of the
coordinates, the formula can be \sQuote{z ~ X + Y}. If
the dependent variable is modeled only as a function of
the mean spatial process, the formula can be \sQuote{z
~ 1}. If no formula is supplied, it defaults to
\sQuote{z ~ 1}.}

\item{overlap.threshold}{a fraction threshold to remove
observations when there is overlap between the
vehicular polygons. A value of 0 does not remove any
observations. A value of 1 removes all observations
that overlap even minimally with neighboring
observations.}

\item{var.label}{optional string to name the final
product. Defaults to \sQuote{yield}.}

\item{boundary}{optional sf object representing the
field's outer boundary. If it not supplied, the
function attempts to generate a boundary from the
observed points.}

\item{clean}{whether to clean the raw data based on
distance from the field edge and global standard
deviation.}

\item{clean.sd}{standard deviation above which the
cleaning step will remove data. Defaults to 3.}

\item{clean.edge.distance}{distance (m) from the field
edge above which the cleaning step will remove data.
Defaults to 0.}

\item{smooth.method}{the smoothing method to be used. If
\sQuote{none}, no smoothing will be conducted. If
\sQuote{idw}, inverse distance weighted interpolation
will be conducted. If \sQuote{krige}, kriging will be
conducted.}

\item{fun}{a function used to transform the data.
Currently, the option are \sQuote{none} and
\sQuote{log}. If none, data operations are carried out
in the data scale. If log, the function will
use\link[gstat]{krigeTg} to perform kriging in the log
scale. For now, only relevant when \sQuote{method} is
krige. the log scale and back transform predictions to
the data scale. When TRUE, \sQuote{fomula} should be
\sQuote{z ~ 1}.}

\item{lbs.per.bushel}{a numeric value representing the
number of pounds in a bushel (e.g., 60 for soybean and
56 for corn). This argument can be ommitted when the
input and output units are in the metric system. It is
necessary otherwise.}

\item{moisture.adj}{an optional numeric value to set the
moisture value to which the yield map predictions
should be adjusted (e.g., 15.5 for corn, and 13.0 for
soybean). If NULL, the function will adjust the
moisture to the average moisture of the field.}

\item{lag.adj}{an optional numeric value used to account
for the time lag between the crop being cut by the
combine and the time at which the combine records a
data point.}

\item{unit.system}{a string representing the unit system
to be used in the function output. If
\sQuote{standard}, the function output will be in
bushel/acre. Alternatively, if \sQuote{metric}, outputs
will be in metric tonnes/hectare.}

\item{remove.crossed.polygons}{logical, whether to remove
vehicle polygons that crossed different experimental
units of the grid. This is intented to prevent from
diluting the treatment effects. When this argument is
TRUE, the argument \sQuote{grid} must be supplied.}

\item{cores}{the number of cores used in the operation}

\item{verbose}{whether to print function progress.
\sQuote{FALSE or 0} will suppress details. \sQuote{TRUE
or 1} will print a progress bar. \sQuote{>1} will print
step by step messages.}

\item{...}{additional arguments to be passed
\link[gstat]{krige} and \link[gstat]{idw}}
}
\value{
an object of class yield
}
\description{
Create an interpolated yield object from
  raw data
}
\details{
This function will follow the steps in the
  selected algorithm to produce a yield map from the raw
  data.
}
\examples{
\dontrun{
extd.dir <- system.file("extdata", package = "pacu")
raw.yield <- sf::read_sf(file.path(extd.dir, '2012-basswood.shp'),
                         quiet = TRUE)
## the simple algorithm
pa_yield(input = raw.yield,
algorithm = 'simple',
unit.system = 'metric',
lbs.per.bushel = 56) ## 56 lb/bushel of maize

## the ritas algorithm
pa_yield(input = raw.yield,
algorithm = 'ritas',
unit.system = 'metric',
lbs.per.bushel = 56)
}

}
\author{
Caio dos Santos and Fernando Miguez
}
