% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_yield.R
\name{pa_check_yield}
\alias{pa_check_yield}
\title{Check the yield data before processing with the
  pa_yield function}
\usage{
pa_check_yield(input, algorithm = c("all", "simple", "ritas"))
}
\arguments{
\item{input}{an sf object containing the input data from
a yield monitor}

\item{algorithm}{for which algorithm should the function
check the data. Different algorithms require different
information to be present in the input data set.}
}
\value{
object of class check.yield
}
\description{
This function will check for red flags so
  the user can know of potential problems before using
  the pa_yield functions
}
\details{
This function will check the input yield data
  for any potential problems before the user runs the
  `pa_yield()` function. Ideally, this function warn the user
  of potential problems.
}
\examples{
\donttest{
extd.dir <- system.file("extdata", package = "pacu")
raw.yield <- sf::read_sf(file.path(extd.dir, '2012-basswood.shp'),
                         quiet = TRUE)
chk <- pa_check_yield(raw.yield)
chk
}

}
\author{
Caio dos Santos and Fernando Miguez
}
