% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill_functions.R
\name{fill_by_function}
\alias{fill_by_function}
\title{Fill missing values by a function of the nonmissings.}
\usage{
fill_by_function(x, ..., fun = mean)
}
\arguments{
\item{x}{A data frame.}

\item{...}{The unquoted column names of the variables that should be filled.}

\item{fun}{The function to apply on the nonmissing values.}
}
\value{
\code{x} with the altered columns.
}
\description{
For each specified column in \code{x} replace the missing values by a
function of the nonmissing values.
}
\examples{
library(dplyr) # for the pipe operator
x <- seq(as.Date('2016-01-01'), by = 'day', length.out = 366)
x <- x[sample(1:366, 200)] \%>\% sort
x_df <- data_frame(x  = x,
                   y1 = runif(200, 10, 20) \%>\% round,
                   y2 = runif(200, 1, 50) \%>\% round)
x_df \%>\% pad \%>\% fill_by_function(y1, y2)
x_df \%>\% pad \%>\% fill_by_function(y1, y2, fun = median)
}

