% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p1app4p2.R
\name{p2.make.pagoda1.app}
\alias{p2.make.pagoda1.app}
\title{Create 'PAGODA1' web application from a 'Pagoda2' object
'PAGODA1' found here, with 'SCDE': <https://www.bioconductor.org/packages/release/bioc/html/scde.html>}
\usage{
p2.make.pagoda1.app(
  p2,
  col.cols = NULL,
  row.clustering = NULL,
  title = "pathway clustering",
  zlim = NULL,
  embedding = NULL,
  inner.clustering = TRUE,
  groups = NULL,
  clusterType = NULL,
  embeddingType = NULL,
  veloinfo = NULL,
  type = "PCA",
  min.group.size = 1,
  batch.colors = NULL,
  n.cores = 10
)
}
\arguments{
\item{p2}{'Pagoda2' object}

\item{col.cols}{Matrix of column colors (default=NULL). Useful for visualizing cell annotations such as batch labels.}

\item{row.clustering}{Row dendrogram (default=NULL)}

\item{title}{character Title to use (default="pathway clustering")}

\item{zlim}{Range of the normalized gene expression levels (default=NULL). Input as a list: c(lower_bound, upper_bound). Values outside this range will be Winsorized. Useful for increasing the contrast of the heatmap visualizations. If NULL, set to the 5th and 95th percentiles.}

\item{embedding}{A 2-D embedding of the cells (PCA, tSNE, etc.), passed as a data frame with two columns (two dimensions) and rows corresponding to cells (row names have to match cell names) (default=NULL).}

\item{inner.clustering}{boolean Whether to get overall cell clustering (default=TRUE).}

\item{groups}{factor describing grouping of different cells. If provided, the cross-fits and the expected expression magnitudes will be determined separately within each group. The factor should have the same length as ncol(counts) (default=NULL).}

\item{clusterType}{cluster type (default=NULL). If NULL, takes the latest cluster in the 'Pagoda2' object using 'p2$clusters[[type]][[1]]'}

\item{embeddingType}{embedding type (default=NULL). If NULL, takes the latest embedding in the 'Pagoda2' object using p2$embeddings[[type]][[1]]}

\item{veloinfo}{cell velocity information, cell velocities (grid and cell) (default=NULL)}

\item{type}{character Either 'counts' or a name of a 'reduction' in the 'Pagoda2' object (default='PCA')}

\item{min.group.size}{integer Minimum group size (default=1)}

\item{batch.colors}{colors of the batches, i.e. the factor (corresponding to rows of the model matrix) specifying batch assignment of each cell(default=NULL)}

\item{n.cores}{numeric Number of cores (default=10)}
}
\value{
'PAGODA1' web application
}
\description{
Create 'PAGODA1' web application from a 'Pagoda2' object
'PAGODA1' found here, with 'SCDE': <https://www.bioconductor.org/packages/release/bioc/html/scde.html>
}
