# palaeoverse <img src="man/figures/logo.png" align="right" width="120" />

<!-- badges: start -->
[![R-CMD-check](https://github.com/palaeoverse-community/palaeoverse/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/palaeoverse-community/palaeoverse/actions/workflows/R-CMD-check.yaml)
[![codecov](https://codecov.io/gh/palaeoverse-community/palaeoverse/branch/main/graph/badge.svg?token=HQQO2CRIKT)](https://app.codecov.io/gh/palaeoverse-community/palaeoverse)
[![CRAN status](https://www.r-pkg.org/badges/version/palaeoverse)](https://CRAN.R-project.org/package=palaeoverse)
[![CRAN downloads](https://cranlogs.r-pkg.org/badges/grand-total/palaeoverse)](https://cran.r-project.org/package=palaeoverse)
[![Twitter URL](https://img.shields.io/twitter/url/https/twitter.com/ThePalaeoverse.svg?style=social&label=Follow%20%40ThePalaeoverse)](https://x.com/ThePalaeoverse)
<!-- badges: end -->

`palaeoverse` is an R package developed by palaeobiologists, for palaeobiologists.

The aim of `palaeoverse` is to generate a community-driven software package of generic functions for the palaeobiological community. The package does not provide implementations of statistical analyses, rather it provides auxiliary functions to help streamline analyses and improve code readability and reproducibility.

# Development team
- [Lewis A. Jones](mailto:LewisAlan.Jones@uvigo.es), Universidade de Vigo
- [William Gearty](mailto:willgearty@gmail.com), American Museum of Natural History
- [Bethany J. Allen](mailto:Bethany.Allen@bsse.ethz.ch), ETH Zürich
- [Kilian Eichenseer](mailto:kilian.eichenseer@gmail.com), Durham University
- [Christopher D. Dean](mailto:christopherdaviddean@gmail.com), University College London
- [Sofía Galván](mailto:sofia.galvan@uvigo.es), Universidade de Vigo
- [Miranta Kouvari](mailto:kouvari.miranta@gmail.com), University College London/Natural History Museum
- [Pedro L. Godoy](mailto:pedrolorenagodoy@gmail.com), University of São Paulo/Stony Brook University
- [Cecily Nicholl](mailto:cecily.nicholl@ucl.ac.uk), University College London
- [Lucas Buffan](mailto:lucas.buffan@ens-lyon.fr), École Normale Supérieure de Lyon
- [Erin M. Dillon](mailto:erinmdillon@ucsb.edu), Smithsonian Tropical Research Institute/University of California
- [A. Alessandro Chiarenza](mailto:a.chiarenza15@gmail.com), Universidade de Vigo

# Installation

The stable version of `palaeoverse` can be installed from CRAN using:

```r
install.packages("palaeoverse")
```

The development version of `palaeoverse` can be installed via GitHub using:

```r
# install.packages("devtools")
devtools::install_github("palaeoverse-community/palaeoverse")
```

# How to contribute?
If you are interested in contributing to the `palaeoverse` R package, you can do so by following these [guidelines](https://palaeoverse.palaeoverse.org/CONTRIBUTING.html). We have also adopted a set of [standards and structure](https://palaeoverse.palaeoverse.org/articles/structure-and-standards.html) to follow for contributing to the project. If you would like to contribute to `palaeoverse`, we strongly advise reading this document.

# Code of Conduct

As with any community project, society, or meeting we feel it is important to established some expectations of behaviour in the `palaeoverse` community. Please read our [code of conduct](https://palaeoverse.palaeoverse.org/CODE_OF_CONDUCT.html), and reach out if you ever face any issues. Everyone has the right to live and work in a harassment-free environment.

# Citation

If you use the palaeoverse R package in your work, please cite as:

Jones, L.A., Gearty, W., Allen, B.J., Eichenseer, K., Dean, C.D., Galván S., Kouvari, M., Godoy, P.L., Nicholl, C., Dillon, E.M., Flannery-Sutherland, J.T., Chiarenza, A.A. 2023. palaeoverse: A community-driven R package to support palaeobiological analysis. *Methods in Ecology and Evolution*. doi: [10.1111/2041-210X.14099](https://doi.org/10.1111/2041-210X.14099).

<p align="left">

<img src="man/figures/logo.png" width="120" />

</p>

<p align="left"; style="font-size:11px">Hexlogo by Miranta Kouvari and Cecily Nicholl</p>
