% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin_lat.R
\name{bin_lat}
\alias{bin_lat}
\title{Assign fossil occurrences to latitudinal bins}
\usage{
bin_lat(occdf, bins, lat = "lat", boundary = FALSE)
}
\arguments{
\item{occdf}{\code{dataframe}. A dataframe of the fossil occurrences you
wish to bin. This dataframe should contain a column with the
latitudinal coordinates of occurrence data.}

\item{bins}{\code{dataframe}. A dataframe of the bins that you wish to
allocate fossil occurrences to, such as that returned by
\code{\link[palaeoverse:lat_bins]{lat_bins()}}. This dataframe must
contain at least the following named columns: "bin", "max" and "min".}

\item{lat}{\code{character}. The name of the column you wish to be treated
as the input latitude (e.g. "lat" or "p_lat"). This column should contain
numerical values. Defaults to "lat".}

\item{boundary}{\code{logical}. If \code{TRUE}, occurrences
falling on the boundaries of latitudinal bins will be duplicated and
assigned to both bins.
If \code{FALSE}, occurrences will be binned into the upper bin
only (i.e. highest row number).}
}
\value{
A dataframe of the original input \code{occdf} with appended
columns containing respective latitudinal bin information.
}
\description{
A function to assign fossil occurrences to user-specified latitudinal bins.
}
\section{Developer(s)}{

Lewis A. Jones
}

\section{Reviewer(s)}{

Sofia Galvan
}

\examples{
# Load occurrence data
occdf <- tetrapods
# Generate latitudinal bins
bins <- lat_bins(size = 10)
# Bin data
occdf <- bin_lat(occdf = occdf, bins = bins, lat = "lat")

}
