% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basics.R
\name{pool.var}
\alias{pool.var}
\title{Compute a pooled variance}
\usage{
pool.var(y, nn = NULL, minN = NULL, ret.paleoTS = FALSE)
}
\arguments{
\item{y}{either a \code{paleoTS} object, or a vector of sample variances}

\item{nn}{a vector of sample sizes}

\item{minN}{sample size below which variances are replaced with pooled
variances. See Details.}

\item{ret.paleoTS}{if TRUE, a \code{paleoTS} object is returned. If FALSE,
the value of the pooled variance is returned.}
}
\value{
if \code{ret.paleoTS = TRUE} a \code{paleoTS} object with all (or
  some) variances replaced with the pooled variance; otherwise the pooled
  variance
}
\description{
Computes a pooled variance from samples in a paleontological
  time-series
}
\details{
A pooled variance of a set of populations is the weighted average
  of the individual variances of the populations, with the weight for each
  population equal to its sample size minus one. \cr \cr For many kinds of
  traits, variation levels tend to be similar among closely related
  populations. When this is true and sample sizes are low, much of the
  observed differences in variance among samples will be due to the high
  noise of estimated the variances. Replacing the observed variances of all
  populations (or only those with \code{nn < minN}) with the estimated pooled
  variance can reduce this noise.
}
\examples{
data(cantius_L)
cant_all <- pool.var(cantius_L, ret.paleoTS = TRUE)   # replace all variances with pooled variance
cant_n5  <- pool.var(cantius_L, minN = 5, ret.paleoTS = TRUE)  # replace only pops with n < 5

}
