% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basics.R
\name{as.paleoTS}
\alias{as.paleoTS}
\title{Make a Paleontological Time-series object}
\usage{
as.paleoTS(
  mm,
  vv,
  nn,
  tt,
  MM = NULL,
  genpars = NULL,
  label = NULL,
  start.age = NULL,
  oldest = c("first", "last"),
  reset.time = TRUE
)
}
\arguments{
\item{mm}{vector of sample means}

\item{vv}{vector of sample variances}

\item{nn}{vector of sample sizes}

\item{tt}{vector of sample ages}

\item{MM}{vector of true means (simulated data)}

\item{genpars}{generating parameters (simulated data)}

\item{label}{optional, label for time-series}

\item{start.age}{optional, age of oldest sample}

\item{oldest}{value indicating if the oldest sample is first or last in the
sequence}

\item{reset.time}{logical; if TRUE, then change time scale to start at t=0
and adjust \code{start.age} accordingly}
}
\value{
a \code{paleoTS} object
}
\description{
Combines information into an object of class \code{paleoTS}
}
\details{
This function combines data into a \code{paleoTS} object. For
  empirical data it may be more convenient to use \code{read.paleoTS}. \cr\cr
  If sample ages decrease through the sequence, as if given in millions of
  years ago, \code{tt} will automatically be converted to time elapsed from
  the beginning of the sequence as long as \code{reset.time} = TRUE.
}
\note{
All model-fitting functions estimate the contribution of sampling
  noise to the observed differences between samples.  They do this assuming
  that the trait is represented by sample means, which have sampling
  variances equal to variance divided by sample size, \code{vv/nn}.  If one
  is interested in analyzing statistics other than the sample mean (medians,
  quantiles, or other statistics), use the the following procedure: set the
  statistic in question as the \code{mm} values, replace \code{vv} with a
  vector of the squared standard errors for each estimate (generated by other
  means, for example bootstrapping), and set all values of \code{nn} to one.
}
\examples{
x <- as.paleoTS(mm = rnorm(20), vv = rep(1, 20), nn = rep(25, 20), tt=1:20)
plot(x) # easier to use sim.Stasis()
}
\seealso{
\code{\link{read.paleoTS}}
}
