% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pfComposite.R
\name{pfComposite}
\alias{pfComposite}
\title{Produce a composite serie from multiple charcoal records}
\usage{
pfComposite(TR, bins = NULL, nboot = 1000, binning = TRUE,
  conf = c(0.05, 0.95))
}
\arguments{
\item{TR}{An object returned by \code{\link{pfTransform}}}

\item{bins}{Numeric, the sequence for binning given in years (e.g.
bins=seq(from=0, to=10000, by=200)). If unspecified the sequence is defined
as bins=seq(from=min age, to=max age, by=median resolution).}

\item{nboot}{Numeric, a number specifying the number of bootstrap
replicates.}

\item{binning}{Logical, set to TRUE (default) for binning, if transformed
data are first interpolated this argument can be set to FALSE (no binning).}

\item{conf}{Numeric, define confidence levels.}
}
\value{
Object of the class "pfComposite"
}
\description{
Produce a composite serie from multiple charcoal records using bootstrap
resampling, the sites charcoal values are binned and the mean in each bin is
calculated prior the bootstrap procedure. This procedure is equivalent to
Power et al. 2008.
}
\examples{
\dontrun{
## Composite charcoal record for boreal Canada:
ID=pfSiteSel(country=="Canada" & l12==1)
plot(ID)
## Transform data
res3=pfTransform(ID,method=c("MinMax","Box-Cox","Z-Score"),BasePeriod=c(200,4000))

## Composite
comp=pfComposite(res3,bins=seq(from=0,to=12000,by=200))
plot(comp)
}
}
\references{
Power, M., J. Marlon, N. Ortiz, P. Bartlein, S. Harrison, F.
Mayle, A. Ballouche, R. Bradshaw, C. Carcaillet, C. Cordova, S. Mooney, P.
Moreno, I. Prentice, K. Thonicke, W. Tinner, C. Whitlock, Y. Zhang, Y. Zhao,
A. Ali, R. Anderson, R. Beer, H. Behling, C. Briles, K. Brown, A. Brunelle,
M. Bush, P. Camill, G. Chu, J. Clark, D. Colombaroli, S. Connor, A. L.
Daniau, M. Daniels, J. Dodson, E. Doughty, M. Edwards, W. Finsinger, D.
Foster, J. Frechette, M. J. Gaillard, D. Gavin, E. Gobet, S. Haberle, D.
Hallett, P. Higuera, G. Hope, S. Horn, J. Inoue, P. Kaltenrieder, L.
Kennedy, Z. Kong, C. Larsen, C. Long, J. Lynch, E. Lynch, M. McGlone, S.
Meeks, S. Mensing, G. Meyer, T. Minckley, J. Mohr, D. Nelson, J. New, R.
Newnham, R. Noti, W. Oswald, J. Pierce, P. Richard, C. Rowe, M. Sanchez
Goni, B. Shuman, H. Takahara, J. Toney, C. Turney, D. Urrego-Sanchez, C.
Umbanhowar, M. Vandergoes, B. Vanniere, E. Vescovi, M. Walsh, X. Wang, N.
Williams, J. Wilmshurst, and J. Zhang. 2008. Changes in fire regimes since
the Last Glacial Maximum: an assessment based on a global synthesis and
analysis of charcoal data. Climate Dynamics 30:887-907.
}
\author{
O.Blarquez
}
