% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pfKruskal.R
\name{plot.pfKruskal}
\alias{plot.pfKruskal}
\title{Plot a "pfKruskal" object.}
\usage{
\method{plot}{pfKruskal}(x, trend = FALSE, outliers = FALSE,
  xlim = NULL, ylim = NULL, ...)
}
\arguments{
\item{x}{An object returned by \code{\link[paleofire]{pfKruskal}}.}

\item{trend}{Logical, show trend using linear regression?}

\item{outliers}{Logical, show outliers?}

\item{xlim}{Numeric, x axis limits.}

\item{ylim}{Numeric, y axis limits.}

\item{\dots}{...}
}
\value{
Return a ggplot2 "gg" object.
}
\description{
Plot a "pfKruskal" object using boxplots and showing significant differences
between the periods using letters.
}
\details{
If two periods share the same letter their rank (median) is not
significantly different at the confidence level specified by \code{alpha}.
If not, equality could be rejected at the confidence level specified by
\code{alpha}.
}
\examples{
\dontrun{
## Composite charcoal record for Western Boreal North America:
ID=pfSiteSel(continent=="North America", long<(-100) & l12==1)
plot(ID)
## Transform data
res3=pfTransform(ID,method=c("MinMax","Box-Cox","Z-Score"),BasePeriod=c(200,4000))

## Composite
comp=pfComposite(res3,bins=seq(from=-500,to=12500,by=1000))
plot(comp)

## Kruskal Wallis Anova
comparison=pfKruskal(comp)

plot(comparison)

# p=plot(comparison)
# require(ggplot2)
# p+ggtitle("my title")
}
}
\seealso{
\code{\link[paleofire]{pfKruskal}}
}
\author{
O. Blarquez
}
