% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{pal.cluster}
\alias{pal.cluster}
\title{Show a palette with heirarchical clustering}
\usage{
pal.cluster(pal, n = 50, type = "LUV", main = "")
}
\arguments{
\item{pal}{A palette function or a vector of colors.}

\item{n}{The number of colors to display for palette functions.}

\item{type}{Either "LUV" (default) or "RGB".}

\item{main}{Title to display at the top of the test image}
}
\value{
None
}
\description{
The palette colors are converted to LUV coordinates before clustering.
(RGB coordinates are available, but not recommended.)
}
\details{
What to look for:

Colors that are visually similar tend to be clustered together.
}
\examples{
pal.cluster(alphabet(), main="alphabet")
pal.cluster(glasbey, main="glasbey") # two royal blues are very similar
pal.cluster(kelly, main="kelly") # two black-ish colors are very similar
# pal.cluster(watlington, main="watlington")
# pal.cluster(coolwarm(15), main="coolwarm") # curiously, grey clusters with blue

}
\references{
None
}
\author{
Kevin Wright
}
