% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-terms.R
\name{get_terms}
\alias{get_terms}
\title{Extract the partial effects of non-linear model terms}
\usage{
get_terms(data, fit, terms, ...)
}
\arguments{
\item{data}{A data frame containing variables used to fit the model. Only
first row will be used.}

\item{fit}{A fitted object of class \code{\link[mgcv]{gam}}.}

\item{terms}{A character vector (can be length one). Specifies the terms
for which partial effects will be returned}

\item{...}{Further arguments passed to \code{\link{seq_range}}.}
}
\value{
A tibble with 5 columns.
}
\description{
This function basically creates a new \code{df} from \code{data} for
each term in \code{terms}, creating a range from minimum and maximum of the
\code{predict(fit, newdata=df, type="terms")}. Terms are then
stacked to a tidy data frame.
}
\examples{
library(survival)
fit <- coxph(Surv(time, status) ~ pspline(karno) + pspline(age), data=veteran)
terms_df <- veteran \%>\% get_terms(fit, terms = c("karno", "age"))
head(terms_df)
tail(terms_df)
}
