% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/S3.R
\name{pander.tabular}
\alias{pander.tabular}
\title{Pander method for tabular class}
\usage{
\method{pander}{tabular}(x, caption = attr(x, "caption"),
  emphasize.rownames = TRUE, digits = panderOptions("digits"), ...)
}
\arguments{
\item{x}{an function object}

\item{caption}{caption (string) to be shown under the table}

\item{emphasize.rownames}{(defaut:\code{TRUE}) if rownames should be highlighted}

\item{digits}{number of digits of precision}

\item{...}{optional parameters passed to raw \code{pandoc.table} function}
}
\description{
Renders an tabular object in Pandoc's markdown.
}
\examples{
library(tables)
pander(tabular(as.factor(am) ~ (mpg+hp+qsec) * (mean+median), data = mtcars), split.tables = Inf)
pander(tabular( (Species + 1) ~ (n=1) + Format(digits=2)*
(Sepal.Length + Sepal.Width)*(mean + sd), data=iris ), split.tables = Inf)
Sex <- factor(sample(c("Male", "Female"), 100, rep=TRUE))
Status <- factor(sample(c("low", "medium", "high"), 100, rep=TRUE))
z <- rnorm(100)+5
fmt <- function(x) {
   s <- format(x, digits=2)
   even <- ((1:length(s)) \%\% 2) == 0
   s[even] <- sprintf("(\%s)", s[even])
   s
}
tab <- tabular( Justify(c)*Heading()*z*Sex*Heading(Statistic)*Format(fmt())*(mean+sd)
               ~ Status )
pander(tab, emphasize.rownames = FALSE)
}

