% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arrange_anova.R
\name{arrange_anova}
\alias{arrange_anova}
\alias{arrange_anova.anova}
\alias{arrange_anova.summary.aov}
\alias{arrange_anova.summary.Anova.mlm}
\title{Create Variance Table from Various ANOVA objects}
\usage{
arrange_anova(x, ...)

\method{arrange_anova}{anova}(x)

\method{arrange_anova}{summary.aov}(x)

\method{arrange_anova}{summary.Anova.mlm}(x, correction = "GG")
}
\arguments{
\item{x}{Output object. See details.}

\item{...}{Further arguments to pass to methods.}

\item{correction}{Character. For \code{summary.Anova.mlm} objects, specifies the type of
sphericity correction to be used. Either \code{GG} for Greenhouse-Geisser or \code{HF}
for Huyn-Feldt methods or \code{none} is also possible. Ignored for other objects.}
}
\value{
\code{data.frame} of class \code{apa_variance_table} or \code{apa_model_comp}.
}
\description{
These methods take objects from various R functions that calculate ANOVA to create
a \code{data.frame} containing a variance table. \emph{This function is not exported
and will most likely be deprecated, soon.}
}
\details{
The returned \code{data.frame} can be passed to functions such as \code{\link[=print_anova]{print_anova()}}.

Currently, methods for the following objects are available:
\itemize{
\item summary.aov
\item summary.aovlist
\item Anova.mlm
}
}
\seealso{
\code{\link[=print_anova]{print_anova()}}, \code{\link[=print_model_comp]{print_model_comp()}}
}
\keyword{internal}
