% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BackendFactory.R
\name{BackendFactory}
\alias{BackendFactory}
\title{BackendFactory}
\description{
This class is a factory that provides concrete implementations of the
\code{\link{Backend}} abstract class.
}
\examples{
# Create a backend factory.
backend_factory <- BackendFactory$new()

# Get a synchronous backend instance.
backend <- backend_factory$get("sync")

# Check the class of the backend instance.
class(backend)

# Get an asynchronous backend instance.
backend <- backend_factory$get("async")

# Check the class of the backend instance.
class(backend)

}
\seealso{
\code{\link{Service}}, \code{\link{Backend}}, \code{\link{SyncBackend}},
\code{\link{AsyncBackend}}, and \code{\link{ContextFactory}}.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BackendFactory-get}{\code{BackendFactory$get()}}
\item \href{#method-BackendFactory-clone}{\code{BackendFactory$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BackendFactory-get"></a>}}
\if{latex}{\out{\hypertarget{method-BackendFactory-get}{}}}
\subsection{Method \code{get()}}{
Obtain a concrete implementation of the abstract \code{\link{Backend}}
class of the specified type.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BackendFactory$get(type)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{A character string specifying the type of the
\code{\link{Backend}} to instantiate. Possible values are \code{"sync"} and
\code{"async"}. See the \strong{Details} section for more information.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
When \code{type = "sync"} a \code{\link{SyncBackend}} instance is created
and returned. When \code{type = "async"} an \code{\link{AsyncBackend}}
instance is provided instead.
}

\subsection{Returns}{
A concrete implementation of the class \code{\link{Backend}}. It
throws an error if the requested backend \code{type} is not supported.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BackendFactory-clone"></a>}}
\if{latex}{\out{\hypertarget{method-BackendFactory-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BackendFactory$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
