% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sampler1D.R
\name{Sampler1DRfun}
\alias{Sampler1DRfun}
\title{Sampler1DRfun Class}
\format{
\link[R6:R6Class]{R6::R6Class} inheriting from \link{Sampler1D}.
}
\description{
Arbitrary sampling from 1D RNG functions from R.
}
\section{Construction}{
\preformatted{smpl = Sampler1DRfun$new(param, rfun, trunc = TRUE)
}
\itemize{
\item \code{param} :: \link{Param}\cr
Domain / support of the distribution we want to sample from.
\item \code{rfun} :: \code{function}\cr
Random number generator function, e.g. \code{rexp} to sample from exponential distribution.
\item \code{trunc} :: \code{logical(1)}\cr
\code{TRUE} enables naive rejection sampling, so we stay inside of [lower, upper].
}
}

\section{Fields}{

See \link{Sampler1D}.
Additionally, the class provides:
\itemize{
\item \code{rfun} :: \verb{function()}\cr
Random number generator function, e.g. \code{rexp} to sample from exponential distribution.
\item \code{trunc} :: \code{logical(1)}\cr
\code{TRUE} enables naive rejection sampling, so we stay inside of [lower, upper].
}
}

\section{Methods}{

See \link{Sampler1D}.
}

\seealso{
Other Sampler: 
\code{\link{Sampler1DCateg}},
\code{\link{Sampler1DNormal}},
\code{\link{Sampler1DUnif}},
\code{\link{Sampler1D}},
\code{\link{SamplerHierarchical}},
\code{\link{SamplerJointIndep}},
\code{\link{SamplerUnif}},
\code{\link{Sampler}}
}
\concept{Sampler}
