% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ps.R
\name{ps}
\alias{ps}
\title{Construct a ParamSet using Short Forms}
\usage{
ps(..., .extra_trafo = NULL, .allow_dangling_dependencies = FALSE)
}
\arguments{
\item{...}{(\code{\link{Domain}} | \code{\link{Param}})\cr
Named arguments of \code{\link{Domain}} or \code{\link{Param}} objects. The \code{\link{ParamSet}} will be constructed of the given \code{\link{Param}}s,
or of \code{\link{Param}}s constructed from the given domains. The names of the arguments will be used as \verb{$id}
(the \verb{$id} of \code{\link{Param}} arguments are ignored).}

\item{.extra_trafo}{(\verb{function(x, param_set)})\cr
Transformation to set the resulting \code{\link{ParamSet}}'s \verb{$trafo} value to. This is in addition to any \code{trafo} of
\code{\link{Domain}} objects given in \code{...}, and will be run \emph{after} transformations of individual parameters were performed.}

\item{.allow_dangling_dependencies}{(\code{logical})\cr
Whether dependencies depending on parameters that are not present should be allowed. A parameter \code{x} having
\code{depends = y == 0} if \code{y} is not present in the \code{ps()} call would usually throw an error, but if dangling
dependencies are allowed, the dependency is added regardless. This is usually a bad idea and mainly for internal
use. Dependencies between \code{\link{ParamSet}}s when using \code{\link[=to_tune]{to_tune()}} can be realized using this.}
}
\value{
A \code{\link{ParamSet}} object.
}
\description{
The \code{ps()} short form constructor uses \code{\link{Domain}} objects (\code{p_dbl}, \code{p_fct}, ...) to construct \code{\link{ParamSet}}s in a
succinct and readable way.

For more specifics also see the documentation of \code{\link{Domain}}.
}
\examples{
pars = ps(
  a = p_int(0, 10),
  b = p_int(upper = 20),
  c = p_dbl(),
  e = p_fct(letters[1:3]),
  f = p_uty(custom_check = checkmate::check_function)
)
print(pars)

pars = ps(
  a = p_dbl(0, 1, trafo = exp),
  b = p_dbl(0, 1, trafo = exp),
  .extra_trafo = function(x, ps) {
    x$c <- x$a + x$b
    x
  }
)

# See how the addition happens after exp()ing:
pars$trafo(list(a = 0, b = 0))

pars$values = list(
  a = to_tune(ps(x = p_int(0, 1),
    .extra_trafo = function(x, param_set) list(a = x$x)
  )),
  # make 'y' depend on 'x', but they are defined in different ParamSets
  # Therefore we need to allow dangling dependencies here.
  b = to_tune(ps(y = p_int(0, 1, depends = x == 1),
    .extra_trafo = function(x, param_set) list(b = x$y),
    .allow_dangling_dependencies = TRUE
  ))
)

pars$search_space()
}
\seealso{
Other ParamSet construction helpers: 
\code{\link{Domain}},
\code{\link{to_tune}()}
}
\concept{ParamSet construction helpers}
