% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{sortComponents}
\alias{sortComponents}
\title{Sort PARAFAC components based on variance explained per component.}
\usage{
sortComponents(Fac, X)
}
\arguments{
\item{Fac}{Fac object output of a \link{parafac} model}

\item{X}{Input data}
}
\value{
Fac object of sorted components
}
\description{
Sort PARAFAC components based on variance explained per component.
}
\examples{
X = array(rnorm(108*100*10), c(108,100,10))
model = parafac(X, 2)
sortedFac = sortComponents(model$Fac, X)
}
