% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoStopCluster.R
\name{autoStopCluster}
\alias{autoStopCluster}
\title{Automatically Stop a Cluster when Garbage Collected}
\usage{
autoStopCluster(cl, debug = FALSE)
}
\arguments{
\item{cl}{A cluster object created by for instance \code{\link[=makeClusterPSOCK]{makeClusterPSOCK()}}
or \code{\link[parallel:makeCluster]{parallel::makeCluster()}}.}

\item{debug}{If TRUE, then debug messages are produced when
the cluster is garbage collected.}
}
\value{
The cluster object with attribute \code{gcMe} set.
}
\description{
Registers a finalizer to a cluster such that the cluster will
be stopped when garbage collected
}
\examples{
options(parallelly.debug = TRUE)

cl <- makeClusterPSOCK(2, dryrun = TRUE)
cl <- autoStopCluster(cl)
print(cl)
rm(list = "cl")
gc()
}
\seealso{
The cluster is stopped using
\code{\link[parallel:makeCluster]{stopCluster}(cl)}.
}
