% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_wald.R, R/p_value_wald.R
\name{ci_wald}
\alias{ci_wald}
\alias{p_value_wald}
\alias{p_value_wald.merMod}
\title{Wald-test approximation for CIs and p-values}
\usage{
ci_wald(
  model,
  ci = 0.95,
  dof = NULL,
  effects = c("fixed", "random", "all"),
  component = c("all", "conditional", "zi", "zero_inflated", "dispersion", "precision",
    "scale", "smooth_terms", "full", "marginal"),
  robust = FALSE,
  ...
)

p_value_wald(model, ...)

\method{p_value_wald}{merMod}(model, dof = Inf, ...)
}
\arguments{
\item{model}{A statistical model.}

\item{ci}{Confidence Interval (CI) level. Default to 0.95 (95\%).}

\item{dof}{Degrees of Freedom. If not specified, for \code{ci_wald()}, defaults to model's residual degrees of freedom (i.e. \code{n-k}, where \code{n} is the number of observations and \code{k} is the number of parameters). For \code{p_value_wald()}, defaults to \code{Inf}.}

\item{effects}{Should standard errors for fixed effects or random effects be
returned? Only applies to mixed models. May be abbreviated. When standard
errors for random effects are requested, for each grouping factor a list of
standard errors (per group level) for random intercepts and slopes is
returned.}

\item{component}{Should all parameters, parameters for the conditional model,
or for the zero-inflated part of the model be returned? Applies to models
with zero-inflated component. \code{component} may be one of \code{"conditional"},
\code{"zi"}, \code{"zero-inflated"} or \code{"all"} (default). May be abbreviated.}

\item{robust}{Logical, if \code{TRUE}, robust standard errors are calculated
(if possible), and confidence intervals and p-values are based on these
robust standard errors. Additional arguments like \code{vcov_estimation} or
\code{vcov_type} are passed down to other methods, see
\code{\link[=standard_error_robust]{standard_error_robust()}} for details.}

\item{...}{Arguments passed down to \code{standard_error_robust()} when confidence intervals or p-values based on robust standard errors should be computed.}
}
\value{
A data frame.
}
\description{
The Wald-test approximation treats t-values as Wald z. Since the t distribution converges to the z distribution as degrees of freedom increase, this is like assuming infinite degrees of freedom. While this is unambiguously anti-conservative, this approximation appears as reasonable for reasonable sample sizes (Barr et al., 2013). That is, if we take the p-value to measure the probability of a false positive, this approximation produces a higher false positive rate than the nominal 5\% at p = 0.05.
}
\examples{
\donttest{
if (require("lme4")) {
  model <- lmer(Petal.Length ~ Sepal.Length + (1 | Species), data = iris)
  p_value_wald(model)
  ci_wald(model, ci = c(0.90, 0.95))
}
}
}
\references{
Barr, D. J. (2013). Random effects structure for testing interactions in linear mixed-effects models. Frontiers in psychology, 4, 328.
}
