% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci.R
\name{ci.merMod}
\alias{ci.merMod}
\alias{ci.glm}
\alias{ci.glmmTMB}
\alias{ci.zeroinfl}
\alias{ci.hurdle}
\alias{ci.MixMod}
\title{Confidence Interval (CI)}
\usage{
\method{ci}{merMod}(x, ci = 0.95, method = c("wald", "kenward",
  "boot"), ...)

\method{ci}{glm}(x, ci = 0.95, method = c("profile", "wald"), ...)

\method{ci}{glmmTMB}(x, ci = 0.95, component = c("all", "conditional",
  "zi", "zero_inflated"), ...)

\method{ci}{zeroinfl}(x, ci = 0.95, component = c("all", "conditional",
  "zi", "zero_inflated"), ...)

\method{ci}{hurdle}(x, ci = 0.95, component = c("all", "conditional",
  "zi", "zero_inflated"), ...)

\method{ci}{MixMod}(x, ci = 0.95, component = c("all", "conditional",
  "zi", "zero_inflated"), ...)
}
\arguments{
\item{x}{A statistical model.}

\item{ci}{Confidence Interval (CI) level. Default to 0.95 (95\%).}

\item{method}{For mixed models of class \code{merMod}, can be \code{\link[=ci_wald]{"wald"}} (default), \code{"kenward"} or \code{"boot"} (see \code{\link{p_value_kenward}} and \code{lme4::confint.merMod}). For generalized linear models, can be \code{"profile"} (default) or \code{"wald"}.}

\item{...}{Arguments passed to or from other methods.}

\item{component}{Should all parameters, parameters for the conditional model,
or for the zero-inflated part of the model be returned? Applies to models
with zero-inflated component. \code{component} may be one of \code{"conditional"},
\code{"zi"}, \code{"zero-inflated"} or \code{"all"} (default). May be abbreviated.}
}
\value{
A data frame containing the CI bounds.
}
\description{
Compute confidence intervals (CI) for frequentist models.
}
\examples{
\donttest{
library(parameters)
library(glmmTMB)

model <- glmmTMB(
  count ~ spp + mined + (1 | site),
  ziformula = ~mined,
  family = poisson(),
  data = Salamanders
)

ci(model)
ci(model, component = "zi")
}
}
