% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4_standard_error.R, R/methods_base.R,
%   R/methods_glmmTMB.R, R/methods_lme4.R
\name{standard_error}
\alias{standard_error}
\alias{standard_error.default}
\alias{standard_error.factor}
\alias{standard_error.glmmTMB}
\alias{standard_error.merMod}
\title{Standard Errors}
\usage{
standard_error(model, ...)

\method{standard_error}{default}(
  model,
  component = "all",
  vcov = NULL,
  vcov_args = NULL,
  verbose = TRUE,
  ...
)

\method{standard_error}{factor}(model, force = FALSE, verbose = TRUE, ...)

\method{standard_error}{glmmTMB}(
  model,
  effects = "fixed",
  component = "all",
  verbose = TRUE,
  ...
)

\method{standard_error}{merMod}(
  model,
  effects = "fixed",
  method = NULL,
  vcov = NULL,
  vcov_args = NULL,
  ...
)
}
\arguments{
\item{model}{A model.}

\item{...}{Arguments passed to or from other methods.}

\item{component}{Model component for which standard errors should be shown.
See the documentation for your object's class in \code{\link[=model_parameters]{model_parameters()}} or
\code{\link[=p_value]{p_value()}} for further details.}

\item{vcov}{Variance-covariance matrix used to compute uncertainty estimates
(e.g., for robust standard errors). This argument accepts a covariance matrix,
a function which returns a covariance matrix, or a string which identifies
the function to be used to compute the covariance matrix.
\itemize{
\item A covariance matrix
\item A function which returns a covariance matrix (e.g., \code{stats::vcov()})
\item A string which indicates the kind of uncertainty estimates to return.
\itemize{
\item Heteroskedasticity-consistent: \code{"vcovHC"}, \code{"HC"}, \code{"HC0"}, \code{"HC1"},
\code{"HC2"}, \code{"HC3"}, \code{"HC4"}, \code{"HC4m"}, \code{"HC5"}. See \code{?sandwich::vcovHC}.
\item Cluster-robust: \code{"vcovCR"}, \code{"CR0"}, \code{"CR1"}, \code{"CR1p"}, \code{"CR1S"},
\code{"CR2"}, \code{"CR3"}. See \code{?clubSandwich::vcovCR}.
\item Bootstrap: \code{"vcovBS"}, \code{"xy"}, \code{"residual"}, \code{"wild"}, \code{"mammen"},
\code{"webb"}. See \code{?sandwich::vcovBS}.
\item Other \code{sandwich} package functions: \code{"vcovHAC"}, \code{"vcovPC"}, \code{"vcovCL"},
\code{"vcovPL"}.
}
}}

\item{vcov_args}{List of arguments to be passed to the function identified by
the \code{vcov} argument. This function is typically supplied by the \strong{sandwich}
or \strong{clubSandwich} packages. Please refer to their documentation (e.g.,
\code{?sandwich::vcovHAC}) to see the list of available arguments.}

\item{verbose}{Toggle warnings and messages.}

\item{force}{Logical, if \code{TRUE}, factors are converted to numerical
values to calculate the standard error, with the lowest level being the
value \code{1} (unless the factor has numeric levels, which are converted
to the corresponding numeric value). By default, \code{NA} is returned for
factors or character vectors.}

\item{effects}{Should standard errors for fixed effects (\code{"fixed"}), random
effects (\code{"random"}), or both (\code{"all"}) be returned? Only applies
to mixed models. May be abbreviated. When standard errors for random
effects are requested, for each grouping factor a list of standard errors
(per group level) for random intercepts and slopes is returned.}

\item{method}{Method for computing degrees of freedom for
confidence intervals (CI) and the related p-values. Allowed are following
options (which vary depending on the model class): \code{"residual"},
\code{"normal"}, \code{"likelihood"}, \code{"satterthwaite"}, \code{"kenward"}, \code{"wald"},
\code{"profile"}, \code{"boot"}, \code{"uniroot"}, \code{"ml1"}, \code{"betwithin"}, \code{"hdi"},
\code{"quantile"}, \code{"ci"}, \code{"eti"}, \code{"si"}, \code{"bci"}, or \code{"bcai"}. See section
\emph{Confidence intervals and approximation of degrees of freedom} in
\code{\link[=model_parameters]{model_parameters()}} for further details.}
}
\value{
A data frame with at least two columns: the parameter names and the
standard errors. Depending on the model, may also include columns for model
components etc.
}
\description{
\code{standard_error()} attempts to return standard errors of model
parameters.
}
\note{
For Bayesian models (from \strong{rstanarm} or \strong{brms}), the standard
error is the SD of the posterior samples.
}
\examples{
\dontshow{if (require("sandwich") && require("clubSandwich")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
model <- lm(Petal.Length ~ Sepal.Length * Species, data = iris)
standard_error(model)

# robust standard errors
standard_error(model, vcov = "HC3")

# cluster-robust standard errors
standard_error(model,
  vcov = "vcovCL",
  vcov_args = list(cluster = iris$Species)
)
\dontshow{\}) # examplesIf}
}
