% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n_clusters.R
\name{n_clusters}
\alias{n_clusters}
\title{Number of Clusters to Extract}
\usage{
n_clusters(x, standardize = TRUE, force = FALSE,
  package = c("NbClust", "mclust", "clValid", "cluster"), fast = TRUE,
  ...)
}
\arguments{
\item{x}{A data frame.}

\item{standardize}{Standardize the dataframe before clustering (default).}

\item{force}{Logical, if \code{TRUE}, factors are converted to numerical
values in order to be included in the data for determining the number of
clusters. By default, factors are removed, because most methods that determine
the number of clusters need numeric input only.}

\item{package}{These are the packages from which methods are used to determine the number of clusters. Can be \code{"all"} or a vector containing \code{"NbClust"}, \code{"mclust"}, \code{"clValid"} and \code{"cluster"}.}

\item{fast}{If \code{FALSE}, will compute 4 more indices (sets \code{index = "allong"} in \code{NbClust}). This has been deactivated by default as it is computationaly heavy.}

\item{...}{Arguments passed to or from other methods.}
}
\description{
This function runs many existing procedures for determining how many clusters are present in your data. It returns the number of clusters based on the maximum consensus. In case of ties, it will select the solution with the less clusters.
}
\examples{
library(parameters)
\donttest{
n_clusters(iris[, 1:4])}
}
