% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/examineKinships.R
\name{examineKinships}
\alias{examineKinships}
\title{Check pedigree for relationship errors}
\usage{
examineKinships(x, who = "all", interfam = c("founders", "none", "all"),
  makeplot = T, showRelationships = c("UN", "PO", "MZ", "S", "H,U,G", "FC",
  "SC"), ...)
}
\arguments{
\item{x}{A \code{\link{linkdat}} object, or a list of such.}

\item{who}{A character vector of one or more of the words 'parents',
 'siblings', 'grandparents', 'cousins', 'distant' and 'unrelated'. Two short
forms are possible: 'all' (all of the above) and 'close' (all of the above
except 'distant' and 'unrelated'.)}

\item{interfam}{A character; either 'founders', 'none' or 'all', indicating
which interfamiliar pairs of individuals should be included. Only relevant
if \code{x} is a list of several \code{linkdat} objects.}

\item{makeplot}{A logical.}

\item{showRelationships}{A character vector passed on to the
\code{relationships} argument of \code{IBDtriangle}.}

\item{\dots}{Other arguments passed on to \code{IBDestimate}.}
}
\value{
A list of matrices (one for each relation category) with IBD estimates.
}
\description{
This function provides a convenient way to check for pedigree errors in a 
linkage project or other situations where marker data is available for several 
members. The function estimates IBD coefficients for all indicated
pairs in the pedigree(s) and produces a color-coded plot where wrong
relationships are easy to spot.
}
\details{
This function works with SNP markers only (for now).
}
\examples{

x = cousinsPed(1)
x = simpleSim(x, 500, alleles=1:2)
examineKinships(x)

# Pretend we didn't know the borthers were related
x1 = branch(x, 3)
x2 = branch(x, 6)
x2$famid = 2

# Notice the grey dot close to the 'S' (siblings)
examineKinships(list(x1, x2))

}
\seealso{
\code{\link{IBDestimate}}, \code{\link{IBDtriangle}}
}
\author{
Magnus Dehli Vigeland
}
