% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kable.R
\name{kable}
\alias{kable}
\title{Create tables in LaTeX, HTML, Markdown and reStructuredText}
\usage{
kable(x, format, digits = getOption("digits"), row.names = NA,
  col.names = colnames(x), align, caption = NULL, escape = TRUE, ...)
}
\arguments{
\item{x}{an R object (typically a matrix or data frame)}

\item{format}{a character string; possible values are \code{latex},
\code{html}, \code{markdown}, \code{pandoc}, and \code{rst}; this will be
automatically determined if the function is called within \pkg{knitr}; it
can also be set in the global option \code{knitr.table.format}}

\item{digits}{the maximum number of digits for numeric columns (passed to
\code{round()}); it can also be a vector of length \code{ncol(x)} to set
the number of digits for individual columns}

\item{row.names}{a logical value indicating whether to include row names; by
default, row names are included if \code{rownames(x)} is neither
\code{NULL} nor identical to \code{1:nrow(x)}}

\item{col.names}{a character vector of column names to be used in the table}

\item{align}{the alignment of columns: a character vector consisting of
\code{'l'} (left), \code{'c'} (center) and/or \code{'r'} (right); by
default, numeric columns are right-aligned, and other columns are
left-aligned; if \code{align = NULL}, the default alignment is used}

\item{caption}{the table caption}

\item{escape}{escape special characters when producing HTML or LaTeX tables}

\item{...}{other arguments (see examples)}
}
\description{
This is a very simple table generator. It is simple by design. It is not
intended to replace any other R packages for making tables.
This is a trimmed down version of the original kable function in knitr package.
Please refer to knitr's \link[knitr]{kable} function for details.
}
\author{
Yihui Xie \href{yihui.name}{http://yihui.name}
}

