% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_dia.R
\encoding{UTF-8}
\name{convert_dia}
\alias{convert_dia}
\title{Searches diagnosis columns for given diseases.}
\usage{
convert_dia(
  d,
  code = "dia_code",
  code_type = "dia_code_type",
  codes_to_find = NULL,
  collapse = NULL,
  code_time = "time_dia",
  time_type = "earliest",
  nThread = 4
)
}
\arguments{
\item{d}{data.table, database containing diagnosis information data loaded using the \emph{load_dia} function.}

\item{code}{string, column name of the diagnosis code column. Defaults to \emph{dia_code}.}

\item{code_type}{string, column name of the code_type column. Defaults to \emph{dia_code_type}.}

\item{codes_to_find}{list, a list of string arrays corresponding to sets of code types and codes separated by \emph{:}, i.e.: "ICD9:250.00".
The function searches for the given disease code type and code pair and adds new boolean columns with the name of each list element.
These columns are indicators whether any of the disease code type and code pair occurs in the set of codes.}

\item{collapse}{string, a column name on which to collapse the data.table.
Used in case we wish to assess whether given disease codes are present within all the same instances of \emph{collapse}. See vignette for details.}

\item{code_time}{string, column name of the time column. Defaults to \emph{time_dia}. Used in case collapse is present to provide the earliest or latest instance of diagnosing the given disease.}

\item{time_type}{string, if multiple diagnoses are present within the same case of \emph{collapse}, which timepoint to return. Supported are: "earliest" or "latest". Defaults to \emph{earliest}.}

\item{nThread}{integer, number of threads to use by \emph{dopar} for parallelization. If it is set to 1, then no parallel backends are created and the function is executed sequentially.
On windows machines sockets are used, while on other operating systems fork parallelization is used.}
}
\value{
data.table, with indicator columns whether the any of the given diagnoses are reported.
If \emph{collapse} is present, then only unique ID and the summary columns are returned.
}
\description{
Analyzes diagnosis data loaded using \emph{load_dia}. Searches diagnosis columns for a specified set of diseases.
By default, the data.table is returned with new columns corresponding to boolean values, whether given group of diagnoses are present in the given diagnosis.
If \emph{collapse} is given, then the information is aggregated based-on the \emph{collapse} column and the earliest of latest time of the given diagnosis is provided.
}
\examples{
\dontrun{
#Search for Hypertension and Stroke ICD codes
diseases <- list(HT = c("ICD10:I10"), Stroke = c("ICD9:434.91", "ICD9:I63.50"))
data_dia_parse <- convert_dia(d = data_dia, codes_to_find = diseases, nThread = 2)

#Search for Hypertension and Stroke ICD codes and summarize per patient providing earliest time
diseases <- list(HT = c("ICD10:I10"), Stroke = c("ICD9:434.91", "ICD9:I63.50"))
data_dia_disease <-  convert_dia(d = data_dia, codes_to_find = diseases,
nThread = 2, collapse = "ID_MERGE", time_type = "earliest")
}
}
