% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_lno.R
\encoding{UTF-8}
\name{load_lno}
\alias{load_lno}
\title{Loads LMR note documents into R.}
\usage{
load_lno(
  file,
  merge_id = "EMPI",
  sep = ":",
  id_length = "standard",
  perc = 0.6,
  na = TRUE,
  identical = TRUE,
  nThread = parallel::detectCores() - 1,
  mrn_type = FALSE
)
}
\arguments{
\item{file}{string, full file path to Lno.txt.}

\item{merge_id}{string, column name to use to create \emph{ID_MERGE} column used to merge different datasets. Defaults to \emph{EPIC_PMRN},
as it is the preferred MRN in the RPDR system.}

\item{sep}{string, divider between hospital ID and MRN. Defaults to \emph{:}.}

\item{id_length}{string, indicating whether to modify MRN length based-on required values \emph{id_length = standard}, or to keep lengths as is \emph{id_length = asis}.
If \emph{id_length = standard} then in case of \emph{MGH, BWH, MCL, EMPI and PMRN} the length of the MRNs are corrected accordingly by adding zeros, or removing numeral from the beginning.
In other cases the lengths are unchanged. Defaults to \emph{standard}.}

\item{perc}{numeric, a number between 0-1 indicating which parsed ID columns to keep. Data present in \emph{perc x 100\%} of patients are kept.}

\item{na}{boolean, whether to remove columns with only NA values. Defaults to \emph{TRUE}.}

\item{identical}{boolean, whether to remove columns with identical values. Defaults to \emph{TRUE}.}

\item{nThread}{integer, number of threads to use to load data.}

\item{mrn_type}{boolean, should data in \emph{MRN_Type} and \emph{MRN} be parsed. Defaults to \emph{FALSE}, as it is not advised to parse these for all data sources as it takes considerable time.}
}
\value{
data table, with LMR notes information.
\describe{
 \item{ID_MERGE}{numeric, defined IDs by \emph{merge_id}, used for merging later.}
 \item{ID_lno_EMPI}{string, Unique Partners-wide identifier assigned to the patient used to consolidate patient information
 from \emph{lno} datasource, corresponds to EMPI in RPDR. Data is formatted using pretty_mrn().}
 \item{ID_lno_PMRN}{string, Epic medical record number. This value is unique across Epic instances within the Partners network
 from \emph{lno} datasource, corresponds to EPIC_PMRN in RPDR. Data is formatted using pretty_mrn().}
 \item{ID_lno_loc}{string, if mrn_type == TRUE, then the data in \emph{MRN_Type} and \emph{MRN} are parsed into IDs corresponding to locations \emph{(loc)}. Data is formatted using pretty_mrn().}
 \item{time_lno}{POSIXct, Date when the report was filed, corresponds to LMRNote_Date in RPDR. Converted to POSIXct format.}
 \item{lno_rec_id}{string, Internal identifier for this report within the LMR system, corresponds to Record_Id in RPDR.}
 \item{lno_status}{string, Completion status of the note, corresponds to Status in RPDR.}
 \item{lno_author}{string, Name of user who created the note, corresponds to Author in RPDR.}
 \item{lno_author_mrn}{string, Author's user identifier within the LMR system, corresponds to Author_MRN in RPDR.}
 \item{lno_COD}{string, Hospital-specific user code of the note author. The first character is a hospital-specific prefix, corresponds to COD in RPDR. Punctuation marks are removed.}
 \item{lno_hosp}{string, Facility where the encounter occurred, corresponds to Institution in RPDR.}
 \item{lno_subject}{string, Type of note. This value is derived from the "Subject" line of the narrative text, corresponds to Subject in RPDR.}
 \item{lno_rep_txt}{string, Full narrative text of the note, corresponds to Comments in RPDR.}
 }
}
\description{
Loads notes from the LMR legacy EHR system.
}
\examples{
\dontrun{
#Using defaults
d_lno <- load_lno(file = "test_Lno.txt")

#Use sequential processing
d_lno <- load_lno(file = "test_Lno.txt", nThread = 1)

#Use parallel processing and parse data in MRN_Type and MRN columns and keep all IDs
d_lno <- load_lno(file = "test_Lno.txt", nThread = 20, mrn_type = TRUE, perc = 1)
}
}
