% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poisson_reg_h2o.R
\name{details_poisson_reg_h2o}
\alias{details_poisson_reg_h2o}
\title{Poisson regression via h2o}
\description{
\code{h2o::h2o.glm()} uses penalized maximum likelihood to fit a model for
count data.
}
\details{
For this engine, there is a single mode: regression
\subsection{Tuning Parameters}{

This model has 2 tuning parameters:
\itemize{
\item \code{mixture}: Proportion of Lasso Penalty (type: double, default: see
below)
\item \code{penalty}: Amount of Regularization (type: double, default: see
below)
}

By default, when not given a fixed \code{penalty},
\code{\link[h2o:h2o.glm]{h2o::h2o.glm()}} uses a heuristic approach to select
the optimal value of \code{penalty} based on training data. Setting the
engine parameter \code{lambda_search} to \code{TRUE} enables an efficient version
of the grid search, see more details at
\url{https://docs.h2o.ai/h2o/latest-stable/h2o-docs/data-science/algo-params/lambda_search.html}.

The choice of \code{mixture} depends on the engine parameter \code{solver}, which
is automatically chosen given training data and the specification of
other model parameters. When \code{solver} is set to \code{'L-BFGS'}, \code{mixture}
defaults to 0 (ridge regression) and 0.5 otherwise.
}

\subsection{Translation from parsnip to the original package}{

\code{\link[agua:h2o_train]{agua::h2o_train_glm()}} for \code{poisson_reg()} is
a wrapper around \code{\link[h2o:h2o.glm]{h2o::h2o.glm()}} with
\code{family = 'poisson'}.

The \strong{agua} extension package is required to fit this model.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(poissonreg)

poisson_reg(penalty = double(1), mixture = double(1)) \%>\% 
  set_engine("h2o") \%>\% 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Poisson Regression Model Specification (regression)
## 
## Main Arguments:
##   penalty = double(1)
##   mixture = double(1)
## 
## Computational engine: h2o 
## 
## Model fit template:
## agua::h2o_train_glm(x = missing_arg(), y = missing_arg(), lambda = double(1), 
##     alpha = double(1), family = "poisson")
}\if{html}{\out{</div>}}
}

\subsection{Preprocessing requirements}{

Factor/categorical predictors need to be converted to numeric values
(e.g., dummy or indicator variables) for this engine. When using the
formula method via \code{\link[=fit.model_spec]{fit()}}, parsnip will
convert factor columns to indicators.

Predictors should have the same scale. One way to achieve this is to
center and scale each so that each predictor has mean zero and a
variance of one.

By default, \code{h2o::h2o.glm()} uses the argument \code{standardize = TRUE} to
center and scale all numerical columns.
}

\subsection{Initializing h2o}{

To use the h2o engine with tidymodels, please run \code{h2o::h2o.init()}
first. By default, This connects R to the local h2o server. This needs
to be done in every new R session. You can also connect to a remote h2o
server with an IP address, for more details see
\code{\link[h2o:h2o.init]{h2o::h2o.init()}}.

You can control the number of threads in the thread pool used by h2o
with the \code{nthreads} argument. By default, it uses all CPUs on the host.
This is different from the usual parallel processing mechanism in
tidymodels for tuning, while tidymodels parallelizes over resamples, h2o
parallelizes over hyperparameter combinations for a given resample.

h2o will automatically shut down the local h2o instance started by R
when R is terminated. To manually stop the h2o server, run
\code{h2o::h2o.shutdown()}.
}
}
\keyword{internal}
