% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decision_tree_rpart.R
\name{details_decision_tree_rpart}
\alias{details_decision_tree_rpart}
\title{Decision trees via CART}
\description{
\code{\link[rpart:rpart]{rpart::rpart()}} fits a model as a set of \verb{if/then} statements that
creates a tree-based structure.
}
\details{
For this engine, there are multiple modes: classification, regression,
and censored regression
\subsection{Tuning Parameters}{

This model has 3 tuning parameters:
\itemize{
\item \code{tree_depth}: Tree Depth (type: integer, default: 30L)
\item \code{min_n}: Minimal Node Size (type: integer, default: 2L)
\item \code{cost_complexity}: Cost-Complexity Parameter (type: double, default:
0.01)
}
}

\subsection{Translation from parsnip to the original package (classification)}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{decision_tree(tree_depth = integer(1), min_n = integer(1), cost_complexity = double(1)) \%>\% 
  set_engine("rpart") \%>\% 
  set_mode("classification") \%>\% 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Decision Tree Model Specification (classification)
## 
## Main Arguments:
##   cost_complexity = double(1)
##   tree_depth = integer(1)
##   min_n = integer(1)
## 
## Computational engine: rpart 
## 
## Model fit template:
## rpart::rpart(formula = missing_arg(), data = missing_arg(), weights = missing_arg(), 
##     cp = double(1), maxdepth = integer(1), minsplit = min_rows(0L, 
##         data))
}\if{html}{\out{</div>}}
}

\subsection{Translation from parsnip to the original package (regression)}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{decision_tree(tree_depth = integer(1), min_n = integer(1), cost_complexity = double(1)) \%>\% 
  set_engine("rpart") \%>\% 
  set_mode("regression") \%>\% 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Decision Tree Model Specification (regression)
## 
## Main Arguments:
##   cost_complexity = double(1)
##   tree_depth = integer(1)
##   min_n = integer(1)
## 
## Computational engine: rpart 
## 
## Model fit template:
## rpart::rpart(formula = missing_arg(), data = missing_arg(), weights = missing_arg(), 
##     cp = double(1), maxdepth = integer(1), minsplit = min_rows(0L, 
##         data))
}\if{html}{\out{</div>}}
}

\subsection{Translation from parsnip to the original package (censored regression)}{

The \strong{censored} extension package is required to fit this model.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(censored)

decision_tree(
  tree_depth = integer(1),
  min_n = integer(1),
  cost_complexity = double(1)
) \%>\% 
  set_engine("rpart") \%>\% 
  set_mode("censored regression") \%>\% 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Decision Tree Model Specification (censored regression)
## 
## Main Arguments:
##   cost_complexity = double(1)
##   tree_depth = integer(1)
##   min_n = integer(1)
## 
## Computational engine: rpart 
## 
## Model fit template:
## pec::pecRpart(formula = missing_arg(), data = missing_arg(), 
##     weights = missing_arg(), cp = double(1), maxdepth = integer(1), 
##     minsplit = min_rows(0L, data))
}\if{html}{\out{</div>}}
}

\subsection{Preprocessing requirements}{

This engine does not require any special encoding of the predictors.
Categorical predictors can be partitioned into groups of factor levels
(e.g. \verb{\{a, c\}} vs \verb{\{b, d\}}) when splitting at a node. Dummy variables
are not required for this model.
}

\subsection{Case weights}{

This model can utilize case weights during model fitting. To use them,
see the documentation in \link{case_weights} and the examples
on \code{tidymodels.org}.

The \code{fit()} and \code{fit_xy()} arguments have arguments called
\code{case_weights} that expect vectors of case weights.
}

\subsection{Other details}{

Predictions of type \code{"time"} are predictions of the mean survival time.
}

\subsection{Examples}{

The “Fitting and Predicting with parsnip” article contains
\href{https://parsnip.tidymodels.org/articles/articles/Examples.html#decision-tree-rpart}{examples}
for \code{decision_tree()} with the \code{"rpart"} engine.
}

\subsection{References}{
\itemize{
\item Kuhn, M, and K Johnson. 2013. \emph{Applied Predictive Modeling}.
Springer.
}
}
}
\keyword{internal}
