% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pls_mixOmics.R
\name{details_pls_mixOmics}
\alias{details_pls_mixOmics}
\title{Partial least squares via mixOmics}
\description{
The mixOmics package can fit several different types of PLS models.
}
\details{
For this engine, there are multiple modes: classification and regression
\subsection{Tuning Parameters}{

This model has 2 tuning parameters:
\itemize{
\item \code{predictor_prop}: Proportion of Predictors (type: double, default:
see below)
\item \code{num_comp}: # Components (type: integer, default: 2L)
}
}

\subsection{Translation from parsnip to the underlying model call (regression)}{

The \strong{plsmod} extension package is required to fit this model.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(plsmod)

pls(num_comp = integer(1), predictor_prop = double(1)) \%>\%
  set_engine("mixOmics") \%>\%
  set_mode("regression") \%>\%
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## PLS Model Specification (regression)
## 
## Main Arguments:
##   predictor_prop = double(1)
##   num_comp = integer(1)
## 
## Computational engine: mixOmics 
## 
## Model fit template:
## plsmod::pls_fit(x = missing_arg(), y = missing_arg(), predictor_prop = double(1), 
##     ncomp = integer(1))
}\if{html}{\out{</div>}}

\code{\link[plsmod:pls_fit]{plsmod::pls_fit()}} is a function that:
\itemize{
\item Determines the number of predictors in the data.
\item Adjusts \code{num_comp} if the value is larger than the number of
factors.
\item Determines whether sparsity is required based on the value of
\code{predictor_prop}.
\item Sets the \code{keepX} argument of \code{mixOmics::spls()} for sparse models.
}
}

\subsection{Translation from parsnip to the underlying model call (classification)}{

The \strong{plsmod} extension package is required to fit this model.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(plsmod)

pls(num_comp = integer(1), predictor_prop = double(1)) \%>\%
  set_engine("mixOmics") \%>\%
  set_mode("classification") \%>\%
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## PLS Model Specification (classification)
## 
## Main Arguments:
##   predictor_prop = double(1)
##   num_comp = integer(1)
## 
## Computational engine: mixOmics 
## 
## Model fit template:
## plsmod::pls_fit(x = missing_arg(), y = missing_arg(), predictor_prop = double(1), 
##     ncomp = integer(1))
}\if{html}{\out{</div>}}

In this case, \code{\link[plsmod:pls_fit]{plsmod::pls_fit()}} has the same role
as above but eventually targets \code{mixOmics::plsda()} or
\code{mixOmics::splsda()}.
}

\subsection{Installing mixOmics}{

This package is available via the Bioconductor repository and is not
accessible via CRAN. You can install using:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{  if (!require("remotes", quietly = TRUE)) \{
    install.packages("remotes")
  \}
  
  remotes::install_bioc("mixOmics")
}\if{html}{\out{</div>}}
}

\subsection{Preprocessing requirements}{

Factor/categorical predictors need to be converted to numeric values
(e.g., dummy or indicator variables) for this engine. When using the
formula method via \code{\link[=fit.model_spec]{fit()}}, parsnip will
convert factor columns to indicators.

Variance calculations are used in these computations so \emph{zero-variance}
predictors (i.e., with a single unique value) should be eliminated
before fitting the model.

Predictors should have the same scale. One way to achieve this is to
center and scale each so that each predictor has mean zero and a
variance of one.
}

\subsection{Case weights}{

The underlying model implementation does not allow for case weights.
}

\subsection{References}{
\itemize{
\item Rohart F and Gautier B and Singh A and Le Cao K-A (2017). “mixOmics:
An R package for ’omics feature selection and multiple data
integration.” PLoS computational biology, 13(11), e1005752.
}
}
}
\keyword{internal}
