% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directors.R
\name{as_director}
\alias{as_director}
\title{Create a custom director}
\usage{
as_director(.pairs, .target, ...)
}
\arguments{
\item{.pairs}{a function that returns a matrix of targets (e.g. a distance matrix of variables)}

\item{.target}{a function that returns a vector of targets (e.g. the minimum pair)}

\item{...}{Extra arguments passed to \code{.f}.}
}
\value{
a function to use in \code{\link[=as_partitioner]{as_partitioner()}}
}
\description{
Directors are functions that tell the partition algorithm what
to try to reduce.  \code{\link[=as_director]{as_director()}} is a helper function to create new
directors to be used in \code{partitioner}s. \code{partitioner}s can be created with
\code{\link[=as_partitioner]{as_partitioner()}}.
}
\examples{
# use euclidean distance to calculate distances
euc_dist <- function(.data) as.matrix(dist(t(.data)))

# find the pair with the minimum distance
min_dist <- function(.x) {
  indices <- arrayInd(which.min(.x), dim(as.matrix(.x)))

  #  get variable names with minimum distance
  c(
    colnames(.x)[indices[1]],
    colnames(.x)[indices[2]]
  )
}

as_director(euc_dist, min_dist)

}
\seealso{
Other directors: \code{\link{direct_distance}},
  \code{\link{direct_k_cluster}}
}
\concept{directors}
