% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_block.R
\name{simulate_block_data}
\alias{simulate_block_data}
\title{Simulate correlated blocks of variables}
\usage{
simulate_block_data(block_sizes, lower_corr, upper_corr, n,
  block_name = "block", sep = "_", var_name = "x")
}
\arguments{
\item{block_sizes}{a vector of block sizes. The size of each block is the
number of variables within it.}

\item{lower_corr}{the lower bound of the correlation within each block}

\item{upper_corr}{the upper bound of the correlation within each block}

\item{n}{the number of observations or rows}

\item{block_name}{description prepended to the variable to indicate the block it belongs to}

\item{sep}{a character, what to separate the variable names with}

\item{var_name}{the name of the variable within the block}
}
\value{
a \code{tibble} with \code{sum(block_sizes)} columns and \code{n} rows.
}
\description{
\code{simulate_block_data()} creates a dataset of blocks of data where variables
within each block are correlated. The correlation for each pair of variables
is sampled uniformly from \code{lower_corr} to \code{upper_corr}, and the values of
each are sampled using \code{\link[MASS:mvrnorm]{MASS::mvrnorm()}}.
}
\examples{
# create a 100 x 15 data set with 3 blocks
simulate_block_data(
  block_sizes = rep(5, 3),
  lower_corr = .4,
  upper_corr = .6,
  n = 100
)
}
