% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/propegate_na.R
\name{propagate_na}
\alias{propagate_na}
\title{Propegate field missingness from higher to lower resolution}
\usage{
propagate_na(x, keep_tz = FALSE)
}
\arguments{
\item{x}{a vector of parttime objects with days which may exceed viable days
of month}

\item{keep_tz}{logical indicating whether to retain timezone fields, even if
other fields are missing}
}
\value{
a \code{partial_time} vector with missingness propagated to lower
resolution time fields
}
\description{
Propegate field missingness from higher to lower resolution
}
\examples{
x <- as.parttime(c("2019", "2019-02-31", "2019-01-05", "2016-02-31",
  "2016-01-05", "2020-01-01 03:04:05.1234"))
vctrs::field(x, "pttm_mat")[,"min"] <- 23
parttime:::propagate_na(x)

}
\keyword{internal}
