% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/location_series_old.R
\name{location_series_old}
\alias{location_series_old}
\title{Extract a time series of bioclimatic variables for one or more locations.}
\usage{
location_series_old(
  x,
  time_bp = NULL,
  bio_variables,
  dataset,
  path_to_nc = NULL
)
}
\arguments{
\item{x}{a data.frame with columns `longitude`, ranging
-180 to 180, and `latitude`, from -90 to 90 (and an optional `name`),
or a vector of cell numbers.}

\item{time_bp}{time slices in years before present (negative values represent
time before present, positive values time in the future). This parameter can
be a vector of times (the slices need
to exist in the dataset), a list with a min and max element setting the
range of values, or left to NULL to retrieve all time steps.
To check which slices are available, you can use
\code{get_time_steps}.}

\item{bio_variables}{vector of names of variables to be extracted.}

\item{dataset}{string defining the dataset to use. If set to "custom",
then a single nc file is used from "path_to_nc"}

\item{path_to_nc}{the path to the custom nc file containing the palaeoclimate
reconstructions. All the variables of interest need to be included in
this file.}
}
\value{
a data.frame with the climatic variables of interest
}
\description{
This function extract a time series of local climate for
 a set of locations. Note that this function does not apply any interpolation
 (as opposed to \code{location_slice}). If you have a coastal location that just
 falls into the water for the reconstructions, you will have to amend the coordinates
 to put it more firmly on land.
}
