% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_functions.R
\name{input_processing}
\alias{input_processing}
\title{Process Input}
\usage{
input_processing(input, p_val_threshold, pin_path, org_dir = NULL,
  human_genes = TRUE)
}
\arguments{
\item{input}{the input data that pathfindR uses. The input must be a data
  frame with three columns: \enumerate{
  \item Gene Symbol (HGNC Gene Symbol)
  \item Change value, e.g. log(fold change) (Not obligatory)
  \item adjusted p value associated with test, e.g. differential expression/methylation
}}

\item{p_val_threshold}{the adjusted-p value threshold to use when filtering
the input data frame}

\item{pin_path}{path to the Protein Interaction Network (PIN) file used in
the analysis}

\item{org_dir}{path/to/original/directory, supplied by run_pathfindR (default = NULL)}

\item{human_genes}{boolean to indicate whether the input genes are human gene symbols or not (default = TRUE)}
}
\value{
This function first filters the input so that all p values are less
  than or equal to the threshold. Next, gene symbols that are not found in
  the PIN are identified. If aliases of these gene symbols are found in the
  PIN, the symbols are converted to the corresponding aliases. The
  resulting data frame containing the original gene symbols, the updated
  symbols, change values and p values is then returned.
}
\description{
Process Input
}
\examples{
\dontshow{
input_processing(RA_input[1:20,], 0.05, return_pin_path("KEGG"))
input_processing(RA_input[1:20,], 0.05, return_pin_path("KEGG"), human_genes = FALSE)
}
\dontrun{
input_processing(RA_input, 0.05, return_pin_path("KEGG"))
}

}
\seealso{
See \code{\link{run_pathfindR}} for the wrapper function of the
  pathfindR workflow
}
