% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_functions.R
\name{fuzzy_term_clustering}
\alias{fuzzy_term_clustering}
\title{Heuristic Fuzzy Multiple-linkage Partitioning of Enriched Terms}
\usage{
fuzzy_term_clustering(kappa_mat, enrichment_res, kappa_threshold = 0.35,
  use_description = FALSE)
}
\arguments{
\item{kappa_mat}{matrix of kappa statistics (output of \code{\link{create_kappa_matrix}})}

\item{enrichment_res}{data frame of pathfindR enrichment results. Must-have
columns are "Term_Description" (if \code{use_description = TRUE}) or "ID"
(if \code{use_description = FALSE}), "Down_regulated", and "Up_regulated".
If \code{use_active_snw_genes = TRUE}, "non_Signif_Snw_Genes" must also be
provided.}

\item{kappa_threshold}{threshold for kappa statistics, defining strong
relation (default = 0.35)}

\item{use_description}{Boolean argument to indicate whether term descriptions
(in the "Term_Description" column) should be used. (default = \code{FALSE})}
}
\value{
a boolean matrix of cluster assignments. Each row corresponds to an
enriched term, each column corresponds to a cluster.
}
\description{
Heuristic Fuzzy Multiple-linkage Partitioning of Enriched Terms
}
\details{
The fuzzy clustering algorithm was implemented based on:
Huang DW, Sherman BT, Tan Q, et al. The DAVID Gene Functional
Classification Tool: a novel biological module-centric algorithm to
functionally analyze large gene lists. Genome Biol. 2007;8(9):R183.
}
\examples{
\dontrun{
fuzzy_term_clustering(kappa_mat, enrichment_res)
fuzzy_term_clustering(kappa_mat, enrichment_res, kappa_threshold = 0.45)
}
}
