% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_functions.R
\name{annotate_term_genes}
\alias{annotate_term_genes}
\title{Annotate the Affected Genes in the Provided Enriched Terms}
\usage{
annotate_term_genes(
  result_df,
  input_processed,
  genes_by_term = pathfindR::kegg_genes
)
}
\arguments{
\item{result_df}{data frame of enrichment results.
The only must-have column is "ID".}

\item{input_processed}{input data processed via \code{\link{input_processing}}}

\item{genes_by_term}{List that contains genes for each gene set. Names of
this list are gene set IDs (default = kegg_genes)}
}
\value{
The original data frame with two additional columns:  \describe{
  \item{Up_regulated}{the up-regulated genes in the input involved in the given term's gene set, comma-separated}
  \item{Down_regulated}{the down-regulated genes in the input involved in the given term's gene set, comma-separated}
}
}
\description{
Function to annotate the involved affected (input) genes in each term.
}
\examples{
example_gene_data <- RA_input
colnames(example_gene_data) <- c("GENE", "CHANGE", "P_VALUE")

annotated_result <- annotate_term_genes(result_df = RA_output,
                                        input_processed = example_gene_data)
}
