% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{rename_viewr_characters}
\alias{rename_viewr_characters}
\title{Rename subjects in the data via pattern detection}
\usage{
rename_viewr_characters(
  obj_name,
  target_column = "subject",
  pattern,
  replacement = ""
)
}
\arguments{
\item{obj_name}{The input viewr object; a tibble or data.frame with attribute
\code{pathviewr_steps} that includes \code{"viewr"}}

\item{target_column}{The target column; defaults to "subject"}

\item{pattern}{The (regex) pattern to be replaced}

\item{replacement}{The replacement text. Must be a character}
}
\value{
A tibble or data frame in which subjects have been renamed according
to the \code{pattern} and \code{replacement} supplied by the user.
}
\description{
Quick utility function to use str_replace with mutate(across()) to batch-
rename subjects via pattern detection.
}
\examples{
## Import the example Motive data included in the package
motive_data <-
  read_motive_csv(system.file("extdata", "pathviewr_motive_example_data.csv",
                             package = 'pathviewr'))

## Clean the file. It is generally recommended to clean up to the
## "gather" step before running rescale_tunnel_data().
 motive_gathered <-
   motive_data \%>\%
   relabel_viewr_axes() \%>\%
   gather_tunnel_data()

## See the subject names
 unique(motive_gathered$subject)

## Now rename the subjects. We'll get rid of "device" and replace it
## with "subject"
motive_renamed <-
  motive_gathered \%>\%
  rename_viewr_characters(target_column = "subject",
                          pattern = "device",
                          replacement = "subject")

## See the new subject names
unique(motive_renamed$subject)
}
\seealso{
Other data cleaning functions: 
\code{\link{gather_tunnel_data}()},
\code{\link{get_full_trajectories}()},
\code{\link{quick_separate_trajectories}()},
\code{\link{redefine_tunnel_center}()},
\code{\link{relabel_viewr_axes}()},
\code{\link{rotate_tunnel}()},
\code{\link{select_x_percent}()},
\code{\link{separate_trajectories}()},
\code{\link{standardize_tunnel}()},
\code{\link{trim_tunnel_outliers}()},
\code{\link{visualize_frame_gap_choice}()}
}
\author{
Vikram B. Baliga
}
\concept{data cleaning functions}
