% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.rimg.R
\name{img_conversion}
\alias{img_conversion}
\alias{rimg2cimg}
\alias{rimg2magick}
\title{Convert images between class rimg and cimg or magick-image}
\usage{
rimg2cimg(image)

rimg2magick(image)
}
\arguments{
\item{image}{an object of class \code{rimg}}
}
\value{
an image of the specified class
}
\description{
Conveniently convert single objects of class \code{rimg} to class \code{cimg} (from the
package \code{imager}) or \code{magick-image} (from the package \code{magick}), both of which
contains a suite of useful image-processing capabilities.
}
\note{
Attributes (e.g. scales, color-classes) will not be preserved following
conversion from class \code{rimg}, so it's best to use early in the analysis workflow.
}
\examples{
papilio <- getimg(system.file("testdata/images/butterflies/papilio.png", package = "pavo"))
\donttest{
# Convert from class rimg to cimg
if (requireNamespace("imager", quiety = TRUE)) {
  papilio_cimg <- rimg2cimg(papilio)
  class(papilio_cimg)
}
}

# Convert from class rimg to magick-image
papilio_magick <- rimg2magick(papilio)
class(papilio_magick)

}
\author{
Thomas E. White \email{thomas.white026@gmail.com}

Hugo Gruson \email{hugo.gruson+R@normalesup.org}
}
