% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emr_operations.R
\name{emr_start_notebook_execution}
\alias{emr_start_notebook_execution}
\title{Starts a notebook execution}
\usage{
emr_start_notebook_execution(EditorId, RelativePath,
  NotebookExecutionName, NotebookParams, ExecutionEngine, ServiceRole,
  NotebookInstanceSecurityGroupId, Tags)
}
\arguments{
\item{EditorId}{[required] The unique identifier of the EMR Notebook to use for notebook execution.}

\item{RelativePath}{[required] The path and file name of the notebook file for this execution, relative
to the path specified for the EMR Notebook. For example, if you specify
a path of \verb{s3://MyBucket/MyNotebooks} when you create an EMR Notebook
for a notebook with an ID of \code{e-ABCDEFGHIJK1234567890ABCD} (the
\code{EditorID} of this request), and you specify a \code{RelativePath} of
\code{my_notebook_executions/notebook_execution.ipynb}, the location of the
file for the notebook execution is
\verb{s3://MyBucket/MyNotebooks/e-ABCDEFGHIJK1234567890ABCD/my_notebook_executions/notebook_execution.ipynb}.}

\item{NotebookExecutionName}{An optional name for the notebook execution.}

\item{NotebookParams}{Input parameters in JSON format passed to the EMR Notebook at runtime
for execution.}

\item{ExecutionEngine}{[required] Specifies the execution engine (cluster) that runs the notebook
execution.}

\item{ServiceRole}{[required] The name or ARN of the IAM role that is used as the service role for
Amazon EMR (the EMR role) for the notebook execution.}

\item{NotebookInstanceSecurityGroupId}{The unique identifier of the Amazon EC2 security group to associate with
the EMR Notebook for this notebook execution.}

\item{Tags}{A list of tags associated with a notebook execution. Tags are
user-defined key-value pairs that consist of a required key string with
a maximum of 128 characters and an optional value string with a maximum
of 256 characters.}
}
\value{
A list with the following syntax:\preformatted{list(
  NotebookExecutionId = "string"
)
}
}
\description{
Starts a notebook execution.
}
\section{Request syntax}{
\preformatted{svc$start_notebook_execution(
  EditorId = "string",
  RelativePath = "string",
  NotebookExecutionName = "string",
  NotebookParams = "string",
  ExecutionEngine = list(
    Id = "string",
    Type = "EMR",
    MasterInstanceSecurityGroupId = "string"
  ),
  ServiceRole = "string",
  NotebookInstanceSecurityGroupId = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
