% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mturk_operations.R
\name{mturk_list_bonus_payments}
\alias{mturk_list_bonus_payments}
\title{The ListBonusPayments operation retrieves the amounts of bonuses you
have paid to Workers for a given HIT or assignment}
\usage{
mturk_list_bonus_payments(HITId, AssignmentId, NextToken, MaxResults)
}
\arguments{
\item{HITId}{The ID of the HIT associated with the bonus payments to retrieve. If not
specified, all bonus payments for all assignments for the given HIT are
returned. Either the HITId parameter or the AssignmentId parameter must
be specified}

\item{AssignmentId}{The ID of the assignment associated with the bonus payments to retrieve.
If specified, only bonus payments for the given assignment are returned.
Either the HITId parameter or the AssignmentId parameter must be
specified}

\item{NextToken}{Pagination token}

\item{MaxResults}{}
}
\value{
A list with the following syntax:\preformatted{list(
  NumResults = 123,
  NextToken = "string",
  BonusPayments = list(
    list(
      WorkerId = "string",
      BonusAmount = "string",
      AssignmentId = "string",
      Reason = "string",
      GrantTime = as.POSIXct(
        "2015-01-01"
      )
    )
  )
)
}
}
\description{
The \code{\link[=mturk_list_bonus_payments]{list_bonus_payments}} operation
retrieves the amounts of bonuses you have paid to Workers for a given
HIT or assignment.
}
\section{Request syntax}{
\preformatted{svc$list_bonus_payments(
  HITId = "string",
  AssignmentId = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
