% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mturk_operations.R
\name{mturk_approve_assignment}
\alias{mturk_approve_assignment}
\title{The ApproveAssignment operation approves the results of a completed
assignment}
\usage{
mturk_approve_assignment(AssignmentId, RequesterFeedback,
  OverrideRejection)
}
\arguments{
\item{AssignmentId}{[required] The ID of the assignment. The assignment must correspond to a HIT
created by the Requester.}

\item{RequesterFeedback}{A message for the Worker, which the Worker can see in the Status section
of the web site.}

\item{OverrideRejection}{A flag indicating that an assignment should be approved even if it was
previously rejected. Defaults to \code{False}.}
}
\description{
The \code{ApproveAssignment} operation approves the results of a completed
assignment.
}
\details{
Approving an assignment initiates two payments from the Requester's
Amazon.com account
\itemize{
\item The Worker who submitted the results is paid the reward specified in
the HIT.
\item Amazon Mechanical Turk fees are debited.
}

If the Requester's account does not have adequate funds for these
payments, the call to ApproveAssignment returns an exception, and the
approval is not processed. You can include an optional feedback message
with the approval, which the Worker can see in the Status section of the
web site.

You can also call this operation for assignments that were previous
rejected and approve them by explicitly overriding the previous
rejection. This only works on rejected assignments that were submitted
within the previous 30 days and only if the assignment's related HIT
has not been deleted.
}
\section{Request syntax}{
\preformatted{svc$approve_assignment(
  AssignmentId = "string",
  RequesterFeedback = "string",
  OverrideRejection = TRUE|FALSE
)
}
}

\keyword{internal}
