% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kafka_operations.R
\name{kafka_list_cluster_operations}
\alias{kafka_list_cluster_operations}
\title{Returns a list of all the operations that have been performed on the
specified MSK cluster}
\usage{
kafka_list_cluster_operations(ClusterArn, MaxResults, NextToken)
}
\arguments{
\item{ClusterArn}{[required]
<p>The Amazon Resource Name (ARN) that uniquely identifies the cluster.</p>}

\item{MaxResults}{<p>The maximum number of results to return in the response. If there are more results, the response includes a NextToken parameter.</p>}

\item{NextToken}{<p>The paginated results marker. When the result of the operation is truncated, the call returns NextToken in the response. 
To get the next batch, provide this token in your next request.</p>}
}
\description{
<p>Returns a list of all the operations that have been performed on the specified MSK cluster.</p>
}
\section{Request syntax}{
\preformatted{svc$list_cluster_operations(
  ClusterArn = "string",
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
