% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_get_user_defined_functions}
\alias{glue_get_user_defined_functions}
\title{Retrieves multiple function definitions from the Data Catalog}
\usage{
glue_get_user_defined_functions(
  CatalogId = NULL,
  DatabaseName = NULL,
  Pattern,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{CatalogId}{The ID of the Data Catalog where the functions to be retrieved are
located. If none is provided, the Amazon Web Services account ID is used
by default.}

\item{DatabaseName}{The name of the catalog database where the functions are located. If
none is provided, functions from all the databases across the catalog
will be returned.}

\item{Pattern}{[required] An optional function-name pattern string that filters the function
definitions returned.}

\item{NextToken}{A continuation token, if this is a continuation call.}

\item{MaxResults}{The maximum number of functions to return in one response.}
}
\description{
Retrieves multiple function definitions from the Data Catalog.

See \url{https://paws-r.github.io/docs/glue/get_user_defined_functions.html} for full documentation.
}
\keyword{internal}
