% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mturk_operations.R
\name{mturk_update_notification_settings}
\alias{mturk_update_notification_settings}
\title{The UpdateNotificationSettings operation creates, updates, disables or
re-enables notifications for a HIT type}
\usage{
mturk_update_notification_settings(
  HITTypeId,
  Notification = NULL,
  Active = NULL
)
}
\arguments{
\item{HITTypeId}{[required] The ID of the HIT type whose notification specification is being
updated.}

\item{Notification}{The notification specification for the HIT type.}

\item{Active}{Specifies whether notifications are sent for HITs of this HIT type,
according to the notification specification. You must specify either the
Notification parameter or the Active parameter for the call to
UpdateNotificationSettings to succeed.}
}
\description{
The \code{\link[=mturk_update_notification_settings]{update_notification_settings}} operation creates, updates, disables or re-enables notifications for a HIT type. If you call the UpdateNotificationSettings operation for a HIT type that already has a notification specification, the operation replaces the old specification with a new one. You can call the UpdateNotificationSettings operation to enable or disable notifications for the HIT type, without having to modify the notification specification itself by providing updates to the Active status without specifying a new notification specification. To change the Active status of a HIT type's notifications, the HIT type must already have a notification specification, or one must be provided in the same call to \code{\link[=mturk_update_notification_settings]{update_notification_settings}}.

See \url{https://paws-r.github.io/docs/mturk/update_notification_settings.html} for full documentation.
}
\keyword{internal}
