% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opensearchservice_operations.R
\name{opensearchservice_update_domain_config}
\alias{opensearchservice_update_domain_config}
\title{Modifies the cluster configuration of the specified domain, such as
setting the instance type and the number of instances}
\usage{
opensearchservice_update_domain_config(
  DomainName,
  ClusterConfig = NULL,
  EBSOptions = NULL,
  SnapshotOptions = NULL,
  VPCOptions = NULL,
  CognitoOptions = NULL,
  AdvancedOptions = NULL,
  AccessPolicies = NULL,
  LogPublishingOptions = NULL,
  EncryptionAtRestOptions = NULL,
  DomainEndpointOptions = NULL,
  NodeToNodeEncryptionOptions = NULL,
  AdvancedSecurityOptions = NULL,
  AutoTuneOptions = NULL,
  DryRun = NULL
)
}
\arguments{
\item{DomainName}{[required] The name of the domain you're updating.}

\item{ClusterConfig}{The type and number of instances to instantiate for the domain cluster.}

\item{EBSOptions}{Specify the type and size of the EBS volume to use.}

\item{SnapshotOptions}{Option to set the time, in UTC format, for the daily automated snapshot.
Default value is \code{0} hours.}

\item{VPCOptions}{Options to specify the subnets and security groups for the VPC endpoint.
For more information, see <a
href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html"
target="_blank">Launching your Amazon OpenSearch Service domains using a
VPC</a> .}

\item{CognitoOptions}{Options to specify the Cognito user and identity pools for OpenSearch
Dashboards authentication. For more information, see <a
href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html"
target="_blank">Configuring Amazon Cognito authentication for OpenSearch
Dashboards</a>.}

\item{AdvancedOptions}{Modifies the advanced option to allow references to indices in an HTTP
request body. Must be \code{false} when configuring access to individual
sub-resources. By default, the value is \code{true}. See <a
href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options"
target="_blank">Advanced options</a> for more information.}

\item{AccessPolicies}{IAM access policy as a JSON-formatted string.}

\item{LogPublishingOptions}{Map of \code{LogType} and \code{LogPublishingOption}, each containing options to
publish a given type of OpenSearch log.}

\item{EncryptionAtRestOptions}{Specifies encryption of data at rest options.}

\item{DomainEndpointOptions}{Options to specify configuration that will be applied to the domain
endpoint.}

\item{NodeToNodeEncryptionOptions}{Specifies node-to-node encryption options.}

\item{AdvancedSecurityOptions}{Specifies advanced security options.}

\item{AutoTuneOptions}{Specifies Auto-Tune options.}

\item{DryRun}{This flag, when set to True, specifies whether the \code{UpdateDomain}
request should return the results of validation checks (DryRunResults)
without actually applying the change.}
}
\description{
Modifies the cluster configuration of the specified domain, such as setting the instance type and the number of instances.

See \url{https://paws-r.github.io/docs/opensearchservice/update_domain_config.html} for full documentation.
}
\keyword{internal}
